/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.having;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.math.BigDecimal;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.query.aggregation.AggregatorFactory;

class HavingSpecMetricComparator {
    static final Pattern LONG_PAT = Pattern.compile("[-|+]?\\d+");

    HavingSpecMetricComparator() {
    }

    static int compare(String aggregationName, Number value, @Nullable Map<String, AggregatorFactory> aggregators, Object metricValueObj) {
        if (value == null) {
            throw DruidException.defensive("Unexpected null match value", new Object[0]);
        }
        if (metricValueObj != null) {
            if (aggregators != null && aggregators.containsKey(aggregationName)) {
                metricValueObj = aggregators.get(aggregationName).finalizeComputation(metricValueObj);
            }
            if (metricValueObj instanceof Long || metricValueObj instanceof Integer) {
                long n = ((Number)metricValueObj).longValue();
                if (value instanceof Long || value instanceof Integer) {
                    return Longs.compare((long)n, (long)value.longValue());
                }
                if (value instanceof Double || value instanceof Float) {
                    return -HavingSpecMetricComparator.compareDoubleToLong(value.doubleValue(), n);
                }
                throw DruidException.defensive("Number was[%s]?!?", value.getClass().getName());
            }
            if (metricValueObj instanceof Double || metricValueObj instanceof Float) {
                double n = ((Number)metricValueObj).doubleValue();
                if (value instanceof Long || value instanceof Integer) {
                    return HavingSpecMetricComparator.compareDoubleToLong(n, value.longValue());
                }
                if (value instanceof Double || value instanceof Float) {
                    return Doubles.compare((double)n, (double)value.doubleValue());
                }
                throw DruidException.defensive("Number was[%s]?!?", value.getClass().getName());
            }
            if (metricValueObj instanceof String) {
                String metricValueStr = (String)metricValueObj;
                if (LONG_PAT.matcher(metricValueStr).matches()) {
                    long l = Long.parseLong(metricValueStr);
                    return Long.compare(l, value.longValue());
                }
                double d = Double.parseDouble(metricValueStr);
                return Double.compare(d, value.doubleValue());
            }
            if (metricValueObj == null) {
                return -1;
            }
            if (aggregators != null && aggregators.containsKey(aggregationName)) {
                AggregatorFactory aggregatorFactory = aggregators.get(aggregationName);
                return aggregatorFactory.getComparator().compare(aggregatorFactory.deserialize(metricValueObj), aggregatorFactory.deserialize(value));
            }
            throw InvalidInput.exception("Unknown type of metric value[%s]", metricValueObj);
        }
        throw DruidException.defensive("Unexpected null metric value", new Object[0]);
    }

    @VisibleForTesting
    static int compareDoubleToLong(double a, long b) {
        if (Double.isNaN(a) || Double.isInfinite(a)) {
            return Double.compare(a, b);
        }
        return BigDecimal.valueOf(a).compareTo(BigDecimal.valueOf(b));
    }
}

