/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.spec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.joda.time.Interval;

public class MultipleIntervalSegmentSpec
implements QuerySegmentSpec {
    private final List<Interval> intervals;

    @JsonCreator
    public MultipleIntervalSegmentSpec(@JsonProperty(value="intervals") List<Interval> intervals) {
        this.intervals = JodaUtils.condenseIntervals(intervals);
    }

    @Override
    @JsonProperty(value="intervals")
    public List<Interval> getIntervals() {
        return this.intervals;
    }

    @Override
    public <T> QueryRunner<T> lookup(Query<T> query, QuerySegmentWalker walker) {
        return walker.getQueryRunnerForIntervals(query, this.intervals);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{intervals=" + String.valueOf(this.intervals) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipleIntervalSegmentSpec that = (MultipleIntervalSegmentSpec)o;
        return Objects.equals(this.intervals, that.intervals);
    }

    public int hashCode() {
        return this.intervals != null ? this.intervals.hashCode() : 0;
    }
}

