/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.segment.ReferenceCountedObjectProvider;
import org.apache.druid.segment.ReferenceCountingCloseableObject;
import org.apache.druid.segment.Segment;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class ReferenceCountedSegmentProvider
extends ReferenceCountingCloseableObject<Segment>
implements Overshadowable<ReferenceCountedSegmentProvider>,
ReferenceCountedObjectProvider<Segment> {
    private final short startRootPartitionId;
    private final short endRootPartitionId;
    private final short minorVersion;
    private final short atomicUpdateGroupSize;

    public static ReferenceCountedSegmentProvider wrapRootGenerationSegment(Segment baseSegment) {
        int partitionNum = baseSegment.getId() == null ? 0 : baseSegment.getId().getPartitionNum();
        return new ReferenceCountedSegmentProvider((Segment)Preconditions.checkNotNull((Object)baseSegment, (Object)"baseSegment"), partitionNum, partitionNum + 1, 0, 1);
    }

    public static ReferenceCountedSegmentProvider wrapSegment(Segment baseSegment, ShardSpec shardSpec) {
        return new ReferenceCountedSegmentProvider(baseSegment, shardSpec.getStartRootPartitionId(), shardSpec.getEndRootPartitionId(), shardSpec.getMinorVersion(), shardSpec.getAtomicUpdateGroupSize());
    }

    public static ReferenceCountedObjectProvider<Segment> wrapUnmanaged(Segment segment) {
        return () -> Optional.of(new UnmanagedReference(segment));
    }

    private ReferenceCountedSegmentProvider(Segment baseSegment, int startRootPartitionId, int endRootPartitionId, short minorVersion, short atomicUpdateGroupSize) {
        super(baseSegment);
        if (baseSegment instanceof ReferenceClosingSegment) {
            throw DruidException.defensive("Cannot use a ReferenceClosingSegment[%s] as baseSegment for a ReferenceCountedSegmentProvider", baseSegment.getDebugString());
        }
        this.startRootPartitionId = (short)startRootPartitionId;
        this.endRootPartitionId = (short)endRootPartitionId;
        this.minorVersion = minorVersion;
        this.atomicUpdateGroupSize = atomicUpdateGroupSize;
    }

    @Nullable
    public Segment getBaseSegment() {
        return !this.isClosed() ? (Segment)this.baseObject : null;
    }

    @Override
    public boolean overshadows(ReferenceCountedSegmentProvider other) {
        if (((Segment)this.baseObject).getId().getDataSource().equals(((Segment)other.baseObject).getId().getDataSource()) && ((Segment)this.baseObject).getId().getInterval().overlaps((ReadableInterval)((Segment)other.baseObject).getId().getInterval())) {
            int majorVersionCompare = ((Segment)this.baseObject).getId().getVersion().compareTo(((Segment)other.baseObject).getId().getVersion());
            if (majorVersionCompare > 0) {
                return true;
            }
            if (majorVersionCompare == 0) {
                return this.includeRootPartitions(other) && this.getMinorVersion() > other.getMinorVersion();
            }
        }
        return false;
    }

    @Override
    public int getStartRootPartitionId() {
        return this.startRootPartitionId;
    }

    @Override
    public int getEndRootPartitionId() {
        return this.endRootPartitionId;
    }

    @Override
    public String getVersion() {
        return ((Segment)this.baseObject).getId().getVersion();
    }

    @Override
    public short getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public short getAtomicUpdateGroupSize() {
        return this.atomicUpdateGroupSize;
    }

    @Override
    public Optional<Segment> acquireReference() {
        Optional<Closeable> reference = this.incrementReferenceAndDecrementOnceCloseable();
        return reference.map(x$0 -> new ReferenceClosingSegment((Closeable)x$0));
    }

    private boolean includeRootPartitions(ReferenceCountedSegmentProvider other) {
        return this.startRootPartitionId <= other.startRootPartitionId && this.endRootPartitionId >= other.endRootPartitionId;
    }

    public final class ReferenceClosingSegment
    extends LeafReference {
        private final Closeable referenceCloseable;
        private final AtomicBoolean isClosed;

        private ReferenceClosingSegment(Closeable referenceCloseable) {
            super((Segment)ReferenceCountedSegmentProvider.this.baseObject);
            this.isClosed = new AtomicBoolean(false);
            this.referenceCloseable = referenceCloseable;
        }

        @Override
        @Nullable
        public <T> T as(@Nonnull Class<T> clazz) {
            if (this.isClosed.get()) {
                throw DruidException.defensive("Segment[%s] reference is already released, cannot get[%s]", ((Segment)ReferenceCountedSegmentProvider.this.baseObject).getId(), clazz);
            }
            return ((Segment)ReferenceCountedSegmentProvider.this.baseObject).as(clazz);
        }

        @Override
        public void close() throws IOException {
            if (!this.isClosed.compareAndSet(false, true)) {
                throw DruidException.defensive("Segment[%s] reference is already released, cannot close again", ((Segment)ReferenceCountedSegmentProvider.this.baseObject).getId());
            }
            this.referenceCloseable.close();
        }

        @VisibleForTesting
        public ReferenceCountedSegmentProvider getProvider() {
            return ReferenceCountedSegmentProvider.this;
        }
    }

    public static final class UnmanagedReference
    extends LeafReference {
        public UnmanagedReference(Segment delegate) {
            super(delegate);
        }

        @Override
        @Nullable
        public <T> T as(@Nonnull Class<T> clazz) {
            return this.baseSegment.as(clazz);
        }

        @Override
        public void close() {
        }
    }

    public static abstract class LeafReference
    implements Segment {
        protected final Segment baseSegment;

        public LeafReference(Segment baseSegment) {
            this.baseSegment = baseSegment;
        }

        @Override
        @Nullable
        public SegmentId getId() {
            return this.baseSegment.getId();
        }

        @Override
        public Interval getDataInterval() {
            return this.baseSegment.getDataInterval();
        }

        @Override
        public boolean isTombstone() {
            return this.baseSegment.isTombstone();
        }

        @Override
        public String getDebugString() {
            return this.baseSegment.getDebugString();
        }

        @Override
        public void validateOrElseThrow(PolicyEnforcer policyEnforcer) {
            policyEnforcer.validateOrElseThrow(this.baseSegment, null);
        }
    }
}

