/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.Closeable;
import java.util.Optional;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;

public abstract class ReferenceCountingCloseableObject<BaseObject extends Closeable>
implements Closeable {
    private static final Logger log = new Logger(ReferenceCountingCloseableObject.class);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    protected final Phaser referents = new Phaser(1){

        @Override
        protected boolean onAdvance(int phase, int registeredParties) {
            if (registeredParties != 0) {
                log.error("registeredParties[%s] is not 0", registeredParties);
            }
            try {
                ReferenceCountingCloseableObject.this.baseObject.close();
            }
            catch (Exception e) {
                try {
                    log.error(e, "Exception while closing reference counted object[%s]", ReferenceCountingCloseableObject.this.baseObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
    };
    protected final BaseObject baseObject;

    public ReferenceCountingCloseableObject(BaseObject object) {
        this.baseObject = object;
    }

    public int getNumReferences() {
        return Math.max(this.referents.getRegisteredParties() - 1, 0);
    }

    public boolean isClosed() {
        return this.referents.isTerminated();
    }

    public boolean increment() {
        return this.referents.register() >= 0;
    }

    public void decrement() {
        this.referents.arriveAndDeregister();
    }

    public Optional<Closeable> incrementReferenceAndDecrementOnceCloseable() {
        Closer closer;
        if (this.increment()) {
            closer = Closer.create();
            closer.register(this.decrementOnceCloseable());
        } else {
            closer = null;
        }
        return Optional.ofNullable(closer);
    }

    public Closeable decrementOnceCloseable() {
        AtomicBoolean decremented = new AtomicBoolean(false);
        return () -> {
            if (decremented.compareAndSet(false, true)) {
                this.decrement();
            } else {
                log.warn("close() is called more than once on ReferenceCountingCloseableObject.decrementOnceCloseable()", new Object[0]);
            }
        };
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.referents.arriveAndDeregister();
        } else {
            log.warn("close() is called more than once on ReferenceCountingCloseableObject", new Object[0]);
        }
    }
}

