/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.segment.nested.NestedPathPart;

public class NestedPathField
implements NestedPathPart {
    private final String field;

    @JsonCreator
    public NestedPathField(@JsonProperty(value="field") String field) {
        this.field = (String)Preconditions.checkNotNull((Object)field, (Object)"partIdentifier must not be null");
    }

    @Override
    public Object find(Object input) {
        if (input instanceof Map) {
            Map currentMap = (Map)input;
            return currentMap.get(this.field);
        }
        return null;
    }

    @Override
    public String getPartIdentifier() {
        return this.field;
    }

    @JsonProperty(value="field")
    public String getField() {
        return this.field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedPathField that = (NestedPathField)o;
        return this.field.equals(that.field);
    }

    public int hashCode() {
        return Objects.hash(this.field);
    }

    public String toString() {
        return "NestedPathField{field='" + this.field + "'}";
    }
}

