/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.metadata.DynamicConfigProvider;

public class DynamicConfigProviderUtils {
    public static Map<String, String> extraConfigAndSetStringMap(@Nullable Map<String, Object> config, String dynamicConfigProviderKey, ObjectMapper mapper) {
        HashMap<String, String> newConfig = new HashMap<String, String>();
        if (config != null) {
            for (Map.Entry<String, Object> entry : config.entrySet()) {
                if (dynamicConfigProviderKey.equals(entry.getKey())) continue;
                newConfig.put(entry.getKey(), entry.getValue().toString());
            }
            Map<String, String> dynamicConfig = DynamicConfigProviderUtils.extraConfigFromProvider(config.get(dynamicConfigProviderKey), mapper);
            newConfig.putAll(dynamicConfig);
        }
        return newConfig;
    }

    public static Map<String, Object> extraConfigAndSetObjectMap(@Nullable Map<String, Object> config, String dynamicConfigProviderKey, ObjectMapper mapper) {
        HashMap<String, Object> newConfig = new HashMap<String, Object>();
        if (config != null) {
            for (Map.Entry<String, Object> entry : config.entrySet()) {
                if (dynamicConfigProviderKey.equals(entry.getKey())) continue;
                newConfig.put(entry.getKey(), entry.getValue());
            }
            Map<String, String> dynamicConfig = DynamicConfigProviderUtils.extraConfigFromProvider(config.get(dynamicConfigProviderKey), mapper);
            newConfig.putAll(dynamicConfig);
        }
        return newConfig;
    }

    private static Map<String, String> extraConfigFromProvider(@Nullable Object dynamicConfigProviderJson, ObjectMapper mapper) {
        if (dynamicConfigProviderJson != null) {
            DynamicConfigProvider dynamicConfigProvider = (DynamicConfigProvider)mapper.convertValue(dynamicConfigProviderJson, DynamicConfigProvider.class);
            return dynamicConfigProvider.getConfig();
        }
        return Collections.emptyMap();
    }
}

