/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.types.numerics.abbreviated;

import com.github.rvesse.airline.types.numerics.abbreviated.MapAbbreviatedNumericTypeConverter;
import java.util.HashMap;
import java.util.Map;

public class SequenceAbbreviatedNumericTypeConverter
extends MapAbbreviatedNumericTypeConverter {
    public SequenceAbbreviatedNumericTypeConverter(boolean caseSensitive, Map<String, Integer> prefixes, long multiplierBase, String ... suffixes) {
        super(caseSensitive, prefixes, SequenceAbbreviatedNumericTypeConverter.buildSuffixes(multiplierBase, suffixes));
    }

    protected static Map<String, Long> buildSuffixes(long base, String ... suffixes) {
        if (base <= 0L) {
            throw new IllegalArgumentException("Base multiplier must be >= 1");
        }
        HashMap<String, Long> suffixMap = new HashMap<String, Long>();
        long m = base;
        for (String s : suffixes) {
            suffixMap.put(s, m);
            long nextM = m * base;
            if (nextM < m) {
                throw new IllegalArgumentException("Too many suffixes leading to numeric overflow");
            }
            m = nextM;
        }
        return suffixMap;
    }
}

