/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.druid.common.config.Configs;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.segment.realtime.appenderator.TaskDirectory;
import org.joda.time.Period;

public class TaskConfig
implements TaskDirectory {
    public static final String ALLOW_HADOOP_TASK_EXECUTION_KEY = "druid.indexer.task.allowHadoopTaskExecution";
    private static final Logger log = new Logger(TaskConfig.class);
    private static final String HADOOP_LIB_VERSIONS = "hadoop.indexer.libs.version";
    public static final List<String> DEFAULT_DEFAULT_HADOOP_COORDINATES;
    private static final Period DEFAULT_DIRECTORY_LOCK_TIMEOUT;
    private static final Period DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT;
    private static final boolean DEFAULT_STORE_EMPTY_COLUMNS = true;
    private static final long DEFAULT_TMP_STORAGE_BYTES_PER_TASK = -1L;
    @JsonProperty
    private final String baseDir;
    @JsonProperty
    private final File baseTaskDir;
    @JsonProperty
    private final String hadoopWorkingPath;
    @JsonProperty
    private final int defaultRowFlushBoundary;
    @JsonProperty
    private final List<String> defaultHadoopCoordinates;
    @JsonProperty
    private final boolean restoreTasksOnRestart;
    @JsonProperty
    private final Period gracefulShutdownTimeout;
    @JsonProperty
    private final Period directoryLockTimeout;
    @JsonProperty
    private final List<StorageLocationConfig> shuffleDataLocations;
    @JsonProperty
    private final boolean ignoreTimestampSpecForDruidInputSource;
    @JsonProperty
    private final boolean storeEmptyColumns;
    @JsonProperty
    private final boolean encapsulatedTask;
    @JsonProperty
    private final long tmpStorageBytesPerTask;
    @JsonProperty
    private final boolean allowHadoopTaskExecution;

    @JsonCreator
    public TaskConfig(@JsonProperty(value="baseDir") String baseDir, @JsonProperty(value="baseTaskDir") String baseTaskDir, @JsonProperty(value="hadoopWorkingPath") String hadoopWorkingPath, @JsonProperty(value="defaultRowFlushBoundary") Integer defaultRowFlushBoundary, @JsonProperty(value="defaultHadoopCoordinates") List<String> defaultHadoopCoordinates, @JsonProperty(value="restoreTasksOnRestart") boolean restoreTasksOnRestart, @JsonProperty(value="gracefulShutdownTimeout") Period gracefulShutdownTimeout, @JsonProperty(value="directoryLockTimeout") Period directoryLockTimeout, @JsonProperty(value="shuffleDataLocations") List<StorageLocationConfig> shuffleDataLocations, @JsonProperty(value="ignoreTimestampSpecForDruidInputSource") boolean ignoreTimestampSpecForDruidInputSource, @JsonProperty(value="storeEmptyColumns") @Nullable Boolean storeEmptyColumns, @JsonProperty(value="encapsulatedTask") boolean enableTaskLevelLogPush, @JsonProperty(value="tmpStorageBytesPerTask") @Nullable Long tmpStorageBytesPerTask, @JsonProperty(value="allowHadoopTaskExecution") boolean allowHadoopTaskExecution) {
        this.baseDir = (String)Configs.valueOrDefault((Object)baseDir, (Object)System.getProperty("java.io.tmpdir"));
        this.baseTaskDir = new File(this.defaultDir(baseTaskDir, "persistent/task"));
        this.hadoopWorkingPath = (String)Configs.valueOrDefault((Object)hadoopWorkingPath, (Object)"/tmp/druid-indexing");
        this.defaultRowFlushBoundary = Configs.valueOrDefault((Integer)defaultRowFlushBoundary, (int)75000);
        this.defaultHadoopCoordinates = (List)Configs.valueOrDefault(defaultHadoopCoordinates, DEFAULT_DEFAULT_HADOOP_COORDINATES);
        this.restoreTasksOnRestart = restoreTasksOnRestart;
        this.gracefulShutdownTimeout = (Period)Configs.valueOrDefault((Object)gracefulShutdownTimeout, (Object)DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT);
        this.directoryLockTimeout = (Period)Configs.valueOrDefault((Object)directoryLockTimeout, (Object)DEFAULT_DIRECTORY_LOCK_TIMEOUT);
        this.shuffleDataLocations = (List)Configs.valueOrDefault(shuffleDataLocations, Collections.singletonList(new StorageLocationConfig(new File(this.defaultDir(null, "intermediary-segments")), null, null)));
        this.ignoreTimestampSpecForDruidInputSource = ignoreTimestampSpecForDruidInputSource;
        this.encapsulatedTask = enableTaskLevelLogPush;
        this.storeEmptyColumns = Configs.valueOrDefault((Boolean)storeEmptyColumns, (boolean)true);
        this.tmpStorageBytesPerTask = Configs.valueOrDefault((Long)tmpStorageBytesPerTask, (long)-1L);
        this.allowHadoopTaskExecution = allowHadoopTaskExecution;
    }

    private TaskConfig(String baseDir, File baseTaskDir, String hadoopWorkingPath, int defaultRowFlushBoundary, List<String> defaultHadoopCoordinates, boolean restoreTasksOnRestart, Period gracefulShutdownTimeout, Period directoryLockTimeout, List<StorageLocationConfig> shuffleDataLocations, boolean ignoreTimestampSpecForDruidInputSource, boolean storeEmptyColumns, boolean encapsulatedTask, long tmpStorageBytesPerTask, boolean allowHadoopTaskExecution) {
        this.baseDir = baseDir;
        this.baseTaskDir = baseTaskDir;
        this.hadoopWorkingPath = hadoopWorkingPath;
        this.defaultRowFlushBoundary = defaultRowFlushBoundary;
        this.defaultHadoopCoordinates = defaultHadoopCoordinates;
        this.restoreTasksOnRestart = restoreTasksOnRestart;
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
        this.directoryLockTimeout = directoryLockTimeout;
        this.shuffleDataLocations = shuffleDataLocations;
        this.ignoreTimestampSpecForDruidInputSource = ignoreTimestampSpecForDruidInputSource;
        this.storeEmptyColumns = storeEmptyColumns;
        this.encapsulatedTask = encapsulatedTask;
        this.tmpStorageBytesPerTask = tmpStorageBytesPerTask;
        this.allowHadoopTaskExecution = allowHadoopTaskExecution;
    }

    @JsonProperty
    public String getBaseDir() {
        return this.baseDir;
    }

    @JsonProperty
    public File getBaseTaskDir() {
        return this.baseTaskDir;
    }

    public File getTaskDir(String taskId) {
        return new File(this.baseTaskDir, IdUtils.validateId((String)"task ID", (String)taskId));
    }

    public File getTaskWorkDir(String taskId) {
        return new File(this.getTaskDir(taskId), "work");
    }

    public File getTaskLogFile(String taskId) {
        return new File(this.getTaskDir(taskId), "log");
    }

    public File getTaskTempDir(String taskId) {
        return new File(this.getTaskDir(taskId), "temp");
    }

    public File getTaskLockFile(String taskId) {
        return new File(this.getTaskDir(taskId), "lock");
    }

    @JsonProperty
    public String getHadoopWorkingPath() {
        return this.hadoopWorkingPath;
    }

    @JsonProperty
    public int getDefaultRowFlushBoundary() {
        return this.defaultRowFlushBoundary;
    }

    @JsonProperty
    public List<String> getDefaultHadoopCoordinates() {
        return this.defaultHadoopCoordinates;
    }

    @JsonProperty
    public boolean isRestoreTasksOnRestart() {
        return this.restoreTasksOnRestart;
    }

    @JsonProperty
    public Period getGracefulShutdownTimeout() {
        return this.gracefulShutdownTimeout;
    }

    @JsonProperty
    public Period getDirectoryLockTimeout() {
        return this.directoryLockTimeout;
    }

    @JsonProperty
    public List<StorageLocationConfig> getShuffleDataLocations() {
        return this.shuffleDataLocations;
    }

    @JsonProperty
    public boolean isIgnoreTimestampSpecForDruidInputSource() {
        return this.ignoreTimestampSpecForDruidInputSource;
    }

    @JsonProperty
    public boolean isStoreEmptyColumns() {
        return this.storeEmptyColumns;
    }

    @JsonProperty
    public boolean isEncapsulatedTask() {
        return this.encapsulatedTask;
    }

    @JsonProperty
    public long getTmpStorageBytesPerTask() {
        return this.tmpStorageBytesPerTask;
    }

    @JsonProperty
    public boolean isAllowHadoopTaskExecution() {
        return this.allowHadoopTaskExecution;
    }

    private String defaultDir(@Nullable String configParameter, String defaultVal) {
        if (configParameter == null) {
            return Paths.get(this.getBaseDir(), defaultVal).toString();
        }
        return configParameter;
    }

    public TaskConfig withBaseTaskDir(File baseTaskDir) {
        return new TaskConfig(this.baseDir, baseTaskDir, this.hadoopWorkingPath, this.defaultRowFlushBoundary, this.defaultHadoopCoordinates, this.restoreTasksOnRestart, this.gracefulShutdownTimeout, this.directoryLockTimeout, this.shuffleDataLocations, this.ignoreTimestampSpecForDruidInputSource, this.storeEmptyColumns, this.encapsulatedTask, this.tmpStorageBytesPerTask, this.allowHadoopTaskExecution);
    }

    public TaskConfig withTmpStorageBytesPerTask(long tmpStorageBytesPerTask) {
        return new TaskConfig(this.baseDir, this.baseTaskDir, this.hadoopWorkingPath, this.defaultRowFlushBoundary, this.defaultHadoopCoordinates, this.restoreTasksOnRestart, this.gracefulShutdownTimeout, this.directoryLockTimeout, this.shuffleDataLocations, this.ignoreTimestampSpecForDruidInputSource, this.storeEmptyColumns, this.encapsulatedTask, tmpStorageBytesPerTask, this.allowHadoopTaskExecution);
    }

    static {
        try {
            DEFAULT_DEFAULT_HADOOP_COORDINATES = ImmutableList.copyOf((Collection)Lists.newArrayList((Object[])IOUtils.toString((InputStream)TaskConfig.class.getResourceAsStream("/hadoop.indexer.libs.version"), (Charset)StandardCharsets.UTF_8).split(",")));
        }
        catch (Exception e) {
            throw new ISE((Throwable)e, "Unable to read file %s from classpath ", new Object[]{HADOOP_LIB_VERSIONS});
        }
        DEFAULT_DIRECTORY_LOCK_TIMEOUT = new Period((Object)"PT10M");
        DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT = new Period((Object)"PT5M");
    }
}

