/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.annotations.SuppressFBWarnings;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.EntryAlreadyExists;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.Counters;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TaskContextEnricher;
import org.apache.druid.indexing.common.task.batch.MaxAllowedLocksExceededException;
import org.apache.druid.indexing.overlord.GlobalTaskLockbox;
import org.apache.druid.indexing.overlord.Stats;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.config.DefaultTaskConfig;
import org.apache.druid.indexing.overlord.config.TaskLockConfig;
import org.apache.druid.indexing.overlord.config.TaskQueueConfig;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.PasswordProvider;
import org.apache.druid.metadata.PasswordProviderRedactionMixIn;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

public class TaskQueue {
    public static final String FAILED_TO_RUN_TASK_SEE_OVERLORD_MSG = "Failed to run task. See overlord logs for more details.";
    private static final long MANAGEMENT_WAIT_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(60L);
    private static final long MIN_WAIT_TIME_MS = 100L;
    private static final long TASK_SIZE_WARNING_THRESHOLD = 0x3C00000L;
    private final ConcurrentHashMap<String, TaskEntry> activeTasks = new ConcurrentHashMap();
    private final TaskLockConfig lockConfig;
    private final TaskQueueConfig config;
    private final DefaultTaskConfig defaultTaskConfig;
    private final TaskStorage taskStorage;
    private final TaskRunner taskRunner;
    private final TaskActionClientFactory taskActionClientFactory;
    private final GlobalTaskLockbox taskLockbox;
    private final ServiceEmitter emitter;
    private final ObjectMapper passwordRedactingMapper;
    private final TaskContextEnricher taskContextEnricher;
    private final ReentrantReadWriteLock startStopLock = new ReentrantReadWriteLock(true);
    private final BlockingQueue<Object> managementMayBeNecessary = new ArrayBlockingQueue<Object>(8);
    private final ExecutorService managerExec = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(false).setNameFormat("TaskQueue-Manager").build());
    private final ScheduledExecutorService storageSyncExec = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(false).setNameFormat("TaskQueue-StorageSync").build());
    private final ExecutorService taskCompleteCallbackExecutor;
    private volatile boolean active = false;
    private static final EmittingLogger log = new EmittingLogger(TaskQueue.class);
    private final ConcurrentHashMap<RowKey, AtomicLong> totalSuccessfulTaskCount = new ConcurrentHashMap();
    private final ConcurrentHashMap<RowKey, AtomicLong> totalFailedTaskCount = new ConcurrentHashMap();
    @GuardedBy(value="totalSuccessfulTaskCount")
    private Map<RowKey, Long> prevTotalSuccessfulTaskCount = new HashMap<RowKey, Long>();
    @GuardedBy(value="totalFailedTaskCount")
    private Map<RowKey, Long> prevTotalFailedTaskCount = new HashMap<RowKey, Long>();
    private final AtomicInteger statusUpdatesInQueue = new AtomicInteger();
    private final AtomicInteger handledStatusUpdates = new AtomicInteger();

    public TaskQueue(TaskLockConfig lockConfig, TaskQueueConfig config, DefaultTaskConfig defaultTaskConfig, TaskStorage taskStorage, TaskRunner taskRunner, TaskActionClientFactory taskActionClientFactory, GlobalTaskLockbox taskLockbox, ServiceEmitter emitter, ObjectMapper mapper, TaskContextEnricher taskContextEnricher) {
        this.lockConfig = (TaskLockConfig)Preconditions.checkNotNull((Object)lockConfig, (Object)"lockConfig");
        this.config = (TaskQueueConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.defaultTaskConfig = (DefaultTaskConfig)Preconditions.checkNotNull((Object)defaultTaskConfig, (Object)"defaultTaskContextConfig");
        this.taskStorage = (TaskStorage)Preconditions.checkNotNull((Object)taskStorage, (Object)"taskStorage");
        this.taskRunner = (TaskRunner)Preconditions.checkNotNull((Object)taskRunner, (Object)"taskRunner");
        this.taskActionClientFactory = (TaskActionClientFactory)Preconditions.checkNotNull((Object)taskActionClientFactory, (Object)"taskActionClientFactory");
        this.taskLockbox = (GlobalTaskLockbox)Preconditions.checkNotNull((Object)taskLockbox, (Object)"taskLockbox");
        this.emitter = (ServiceEmitter)Preconditions.checkNotNull((Object)emitter, (Object)"emitter");
        this.taskCompleteCallbackExecutor = Execs.multiThreaded((int)config.getTaskCompleteHandlerNumThreads(), (String)"TaskQueue-OnComplete-%d");
        this.passwordRedactingMapper = mapper.copy().addMixIn(PasswordProvider.class, PasswordProviderRedactionMixIn.class);
        this.taskContextEnricher = (TaskContextEnricher)Preconditions.checkNotNull((Object)taskContextEnricher, (Object)"taskContextEnricher");
    }

    @VisibleForTesting
    void setActive(boolean active) {
        this.startStopLock.writeLock().lock();
        try {
            this.active = active;
        }
        finally {
            this.startStopLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        this.startStopLock.writeLock().lock();
        try {
            Preconditions.checkState((!this.active ? 1 : 0) != 0, (Object)"queue must be stopped");
            this.setActive(true);
            Set<Task> tasksToFail = this.taskLockbox.syncFromStorage().getTasksToFail();
            this.syncFromStorage();
            for (Task task : tasksToFail) {
                this.shutdown(task.getId(), "Shutting down forcefully as task failed to reacquire lock while becoming leader", new Object[0]);
            }
            this.managerExec.submit(() -> {
                while (true) {
                    try {
                        this.manage();
                    }
                    catch (InterruptedException e) {
                        log.info("Interrupted, exiting!", new Object[0]);
                    }
                    catch (Exception e) {
                        long restartDelay = this.config.getRestartDelay().getMillis();
                        log.makeAlert((Throwable)e, "Failed to manage", new Object[0]).addData("restartDelay", (Object)restartDelay).emit();
                        try {
                            Thread.sleep(restartDelay);
                        }
                        catch (InterruptedException e2) {
                            log.info("Interrupted, exiting!", new Object[0]);
                            break;
                        }
                    }
                }
            });
            ScheduledExecutors.scheduleAtFixedRate((ScheduledExecutorService)this.storageSyncExec, (Duration)this.config.getStorageSyncRate(), () -> {
                block3: {
                    try {
                        this.syncFromStorage();
                    }
                    catch (Exception e) {
                        if (!this.active) break block3;
                        log.makeAlert((Throwable)e, "Failed to sync with storage", new Object[0]).emit();
                    }
                }
                if (this.active) {
                    return ScheduledExecutors.Signal.REPEAT;
                }
                return ScheduledExecutors.Signal.STOP;
            });
            this.requestManagement();
            for (Task task : tasksToFail) {
                for (TaskLock lock : this.taskStorage.getLocks(task.getId())) {
                    this.taskStorage.removeLock(task.getId(), lock);
                }
            }
        }
        finally {
            this.startStopLock.writeLock().unlock();
        }
    }

    @LifecycleStop
    public void stop() {
        this.startStopLock.writeLock().lock();
        try {
            this.setActive(false);
            this.activeTasks.clear();
            this.taskLockbox.shutdown();
            this.managerExec.shutdownNow();
            this.storageSyncExec.shutdownNow();
            this.requestManagement();
        }
        finally {
            this.startStopLock.writeLock().unlock();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private void requestManagement() {
        this.managementMayBeNecessary.offer(this);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="using queue as notification mechanism, result has no value")
    private void awaitManagement() throws InterruptedException {
        Thread.sleep(100L);
        this.managementMayBeNecessary.poll(MANAGEMENT_WAIT_TIMEOUT_NANOS - TimeUnit.MILLISECONDS.toNanos(100L), TimeUnit.NANOSECONDS);
        this.managementMayBeNecessary.clear();
    }

    private void manage() throws InterruptedException {
        log.info("Beginning management in [%s].", new Object[]{this.config.getStartDelay()});
        Thread.sleep(this.config.getStartDelay().getMillis());
        this.taskRunner.restore();
        while (this.active) {
            this.manageQueuedTasks();
            this.awaitManagement();
        }
    }

    @VisibleForTesting
    void manageQueuedTasks() {
        this.startStopLock.readLock().lock();
        try {
            this.startPendingTasksOnRunner();
        }
        finally {
            this.startStopLock.readLock().unlock();
        }
    }

    @GuardedBy(value="startStopLock")
    private void startPendingTasksOnRunner() {
        HashSet unknownTaskIds = new HashSet();
        HashMap runnerTaskFutures = new HashMap();
        for (TaskRunnerWorkItem taskRunnerWorkItem : List.copyOf(this.taskRunner.getKnownTasks())) {
            String taskId = taskRunnerWorkItem.getTaskId();
            this.updateTaskEntry(taskId, entry -> {
                if (entry == null) {
                    unknownTaskIds.add(taskId);
                    this.shutdownUnknownTaskOnRunner(taskId);
                } else {
                    runnerTaskFutures.put(taskId, taskRunnerWorkItem.getResult());
                }
            });
        }
        log.info("Cleaned up [%,d] tasks on task runner with IDs[%s].", new Object[]{unknownTaskIds.size(), unknownTaskIds});
        for (String string : List.copyOf(this.activeTasks.keySet())) {
            this.updateTaskEntry(string, entry -> this.startPendingTaskOnRunner((TaskEntry)entry, (ListenableFuture<TaskStatus>)((ListenableFuture)runnerTaskFutures.get(queuedTaskId))));
        }
    }

    @GuardedBy(value="startStopLock")
    private void startPendingTaskOnRunner(TaskEntry entry, ListenableFuture<TaskStatus> runnerTaskFuture) {
        if (entry != null && !entry.isComplete) {
            Task task = entry.task;
            if (entry.future == null) {
                if (runnerTaskFuture == null) {
                    boolean taskIsReady;
                    try {
                        taskIsReady = task.isReady(this.taskActionClientFactory.create(task));
                    }
                    catch (Exception e) {
                        log.warn((Throwable)e, "Exception thrown during isReady for task: %s", new Object[]{task.getId()});
                        String errorMessage = e instanceof MaxAllowedLocksExceededException || e instanceof DruidException ? e.getMessage() : StringUtils.format((String)"Encountered error[%s] while waiting for task to be ready. See Overlord logs for more details.", (Object[])new Object[]{e.getMessage()});
                        TaskStatus taskStatus = TaskStatus.failure((String)task.getId(), (String)errorMessage);
                        this.notifyStatus(entry, taskStatus, taskStatus.getErrorMsg(), new Object[0]);
                        this.emitTaskCompletionLogsAndMetrics(task, taskStatus);
                        return;
                    }
                    if (taskIsReady) {
                        log.info("Asking taskRunner to run task[%s]", new Object[]{task.getId()});
                        runnerTaskFuture = this.taskRunner.run(task);
                    } else {
                        this.taskLockbox.unlockAll(task);
                        return;
                    }
                }
                this.attachCallbacks(task, runnerTaskFuture);
                entry.future = runnerTaskFuture;
            } else if (this.isTaskPending(task)) {
                this.taskRunner.run(task);
            }
        }
    }

    private void shutdownUnknownTaskOnRunner(String taskId) {
        try {
            this.taskRunner.shutdown(taskId, "Task is not present in queue anymore.");
        }
        catch (Exception e) {
            log.warn((Throwable)e, "TaskRunner failed to clean up task[%s].", new Object[]{taskId});
        }
    }

    private boolean isTaskPending(Task task) {
        return this.taskRunner.getPendingTasks().stream().anyMatch(workItem -> workItem.getTaskId().equals(task.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Task task) {
        IdUtils.validateId((String)"Task ID", (String)task.getId());
        if (this.taskStorage.getTask(task.getId()).isPresent()) {
            throw EntryAlreadyExists.exception((String)"Task[%s] already exists", (Object[])new Object[]{task.getId()});
        }
        this.validateTaskPayload(task);
        task.addToContextIfAbsent("forceTimeChunkLock", this.lockConfig.isForceTimeChunkLock());
        this.defaultTaskConfig.getContext().forEach(task::addToContextIfAbsent);
        task.addToContextIfAbsent("useLineageBasedSegmentAllocation", true);
        this.taskContextEnricher.enrichContext(task);
        this.startStopLock.readLock().lock();
        try {
            Preconditions.checkState((boolean)this.active, (Object)"Queue is not active!");
            Preconditions.checkNotNull((Object)task, (Object)"task");
            if (this.activeTasks.size() >= this.config.getMaxSize()) {
                throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.ADMIN).ofCategory(DruidException.Category.CAPACITY_EXCEEDED).build("Task queue already contains [%d] tasks. Retry later or increase 'druid.indexer.queue.maxSize'[%d].", new Object[]{this.activeTasks.size(), this.config.getMaxSize()});
            }
            DateTime insertTime = DateTimes.nowUtc();
            this.taskStorage.insert(task, TaskStatus.running((String)task.getId()));
            this.addTaskInternal(task, insertTime);
            this.requestManagement();
            boolean bl = true;
            return bl;
        }
        finally {
            this.startStopLock.readLock().unlock();
        }
    }

    @GuardedBy(value="startStopLock")
    private void addTaskInternal(Task task, DateTime updateTime) {
        AtomicBoolean added = new AtomicBoolean(false);
        TaskEntry entry = this.addOrUpdateTaskEntry(task.getId(), prevEntry -> {
            if (prevEntry == null) {
                added.set(true);
                return new TaskEntry(task);
            }
            if (prevEntry.lastUpdatedTime.isBefore((ReadableInstant)updateTime)) {
                prevEntry.lastUpdatedTime = updateTime;
            }
            return prevEntry;
        });
        if (added.get()) {
            this.taskLockbox.add(task);
        } else if (!entry.task.equals(task)) {
            throw new ISE("Cannot add task[%s] as a different task for the same ID has already been added.", new Object[]{task.getId()});
        }
    }

    @GuardedBy(value="startStopLock")
    private boolean removeTaskInternal(String taskId, DateTime deleteTime) {
        AtomicReference removedTask = new AtomicReference();
        this.addOrUpdateTaskEntry(taskId, prevEntry -> {
            if (prevEntry != null && (prevEntry.isComplete || prevEntry.lastUpdatedTime.isBefore((ReadableInstant)deleteTime))) {
                removedTask.set(prevEntry.task);
                return null;
            }
            return prevEntry;
        });
        if (removedTask.get() != null) {
            this.removeTaskLock((Task)removedTask.get());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String taskId, String reasonFormat, Object ... args) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId");
        this.startStopLock.readLock().lock();
        try {
            this.updateTaskEntry(taskId, entry -> this.notifyStatus((TaskEntry)entry, TaskStatus.failure((String)taskId, (String)StringUtils.format((String)reasonFormat, (Object[])args)), reasonFormat, args));
        }
        finally {
            this.startStopLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownWithSuccess(String taskId, String reasonFormat, Object ... args) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId");
        this.startStopLock.readLock().lock();
        try {
            this.updateTaskEntry(taskId, entry -> this.notifyStatus((TaskEntry)entry, TaskStatus.success((String)taskId), reasonFormat, args));
        }
        finally {
            this.startStopLock.readLock().unlock();
        }
    }

    private void notifyStatus(TaskEntry entry, TaskStatus taskStatus, String reasonFormat, Object ... args) {
        if (entry == null) {
            return;
        }
        Task task = entry.task;
        Preconditions.checkNotNull((Object)task, (Object)"task");
        Preconditions.checkNotNull((Object)taskStatus, (Object)"status");
        Preconditions.checkState((boolean)this.active, (Object)"Queue is not active!");
        Preconditions.checkArgument((boolean)task.getId().equals(taskStatus.getId()), (String)"Mismatching task ids[%s/%s]", (Object)task.getId(), (Object)taskStatus.getId());
        if (!taskStatus.isComplete()) {
            return;
        }
        if (entry.isComplete) {
            log.info("Ignoring notification with status[%s] for already completed task[%s]", new Object[]{taskStatus, task.getId()});
            return;
        }
        entry.isComplete = true;
        TaskLocation taskLocation = this.taskRunner.getTaskLocation(task.getId());
        try {
            Optional<TaskStatus> previousStatus = this.taskStorage.getStatus(task.getId());
            if (!previousStatus.isPresent() || ((TaskStatus)previousStatus.get()).isComplete()) {
                log.makeAlert("Ignoring notification for already-complete task", new Object[0]).addData("task", (Object)task.getId()).emit();
            } else {
                this.taskStorage.setStatus(taskStatus.withLocation(taskLocation));
            }
        }
        catch (Throwable e) {
            log.makeAlert(e, "Failed to persist status for task", new Object[0]).addData("task", (Object)task.getId()).addData("statusCode", (Object)taskStatus.getStatusCode()).emit();
        }
        try {
            this.taskRunner.shutdown(task.getId(), reasonFormat, args);
        }
        catch (Throwable e) {
            log.warn(e, "TaskRunner failed to cleanup task after completion: %s", new Object[]{task.getId()});
        }
        this.removeTaskLock(task);
        this.requestManagement();
        log.info("Completed notifyStatus for task[%s] with status[%s]", new Object[]{task.getId(), taskStatus});
    }

    private void attachCallbacks(final Task task, ListenableFuture<TaskStatus> statusFuture) {
        Futures.addCallback(statusFuture, (FutureCallback)new FutureCallback<TaskStatus>(){

            public void onSuccess(TaskStatus status) {
                log.info("Received status[%s] for task[%s].", new Object[]{status.getStatusCode(), status.getId()});
                TaskQueue.this.statusUpdatesInQueue.incrementAndGet();
                TaskQueue.this.taskCompleteCallbackExecutor.execute(() -> this.handleStatus(status));
            }

            public void onFailure(Throwable t) {
                log.makeAlert(t, "Failed to run task", new Object[0]).addData("task", (Object)task.getId()).addData("type", (Object)task.getType()).addData("dataSource", (Object)task.getDataSource()).emit();
                TaskQueue.this.statusUpdatesInQueue.incrementAndGet();
                TaskStatus status = TaskStatus.failure((String)task.getId(), (String)TaskQueue.FAILED_TO_RUN_TASK_SEE_OVERLORD_MSG);
                TaskQueue.this.taskCompleteCallbackExecutor.execute(() -> this.handleStatus(status));
            }

            private void handleStatus(TaskStatus status) {
                try {
                    if (!TaskQueue.this.active) {
                        log.info("Abandoning task [%s] due to shutdown.", new Object[]{task.getId()});
                        return;
                    }
                    TaskQueue.this.updateTaskEntry(task.getId(), entry -> TaskQueue.this.notifyStatus((TaskEntry)entry, status, "notified status change from task", new Object[0]));
                    TaskQueue.this.emitTaskCompletionLogsAndMetrics(task, status);
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Failed to handle task status", new Object[0]).addData("task", (Object)task.getId()).addData("statusCode", (Object)status.getStatusCode()).emit();
                }
                finally {
                    TaskQueue.this.statusUpdatesInQueue.decrementAndGet();
                    TaskQueue.this.handledStatusUpdates.incrementAndGet();
                }
            }
        }, (Executor)Execs.directExecutor());
    }

    @VisibleForTesting
    void syncFromStorage() {
        this.startStopLock.readLock().lock();
        DateTime syncStartTime = DateTimes.nowUtc();
        try {
            if (this.active) {
                Map newTasks = CollectionUtils.toMap(this.taskStorage.getActiveTasks(), Task::getId, Function.identity());
                Map oldTasks = CollectionUtils.mapValues(this.activeTasks, entry -> entry.task);
                MapDifference mapDifference = Maps.difference((Map)oldTasks, (Map)newTasks);
                Collection addedTasks = mapDifference.entriesOnlyOnRight().values();
                Collection removedTasks = mapDifference.entriesOnlyOnLeft().values();
                int numTasksRemoved = 0;
                for (Task task : removedTasks) {
                    if (!this.removeTaskInternal(task.getId(), syncStartTime)) continue;
                    ++numTasksRemoved;
                }
                for (Task task : addedTasks) {
                    this.addTaskInternal(task, syncStartTime);
                }
                log.info("Synced [%d] tasks from storage (%d tasks added, %d tasks removable, %d tasks removed).", new Object[]{newTasks.size(), addedTasks.size(), removedTasks.size(), numTasksRemoved});
                this.requestManagement();
            } else {
                log.info("Not active. Skipping storage sync.", new Object[0]);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to sync tasks from storage!", new Object[0]);
            throw new RuntimeException(e);
        }
        finally {
            this.startStopLock.readLock().unlock();
        }
    }

    private static Map<String, Task> toTaskIDMap(List<Task> taskList) {
        HashMap<String, Task> rv = new HashMap<String, Task>();
        for (Task task : taskList) {
            rv.put(task.getId(), task);
        }
        return rv;
    }

    private Map<RowKey, Long> getDeltaValues(Map<RowKey, Long> total, Map<RowKey, Long> prev) {
        HashMap<RowKey, Long> deltaValues = new HashMap<RowKey, Long>();
        total.forEach((dataSource, totalCount) -> deltaValues.put((RowKey)dataSource, totalCount - prev.getOrDefault(dataSource, 0L)));
        return deltaValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<RowKey, Long> getSuccessfulTaskCount() {
        Map total = CollectionUtils.mapValues(this.totalSuccessfulTaskCount, AtomicLong::get);
        ConcurrentHashMap<RowKey, AtomicLong> concurrentHashMap = this.totalSuccessfulTaskCount;
        synchronized (concurrentHashMap) {
            Map<RowKey, Long> delta = this.getDeltaValues(total, this.prevTotalSuccessfulTaskCount);
            this.prevTotalSuccessfulTaskCount = total;
            return delta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<RowKey, Long> getFailedTaskCount() {
        Map total = CollectionUtils.mapValues(this.totalFailedTaskCount, AtomicLong::get);
        ConcurrentHashMap<RowKey, AtomicLong> concurrentHashMap = this.totalFailedTaskCount;
        synchronized (concurrentHashMap) {
            Map<RowKey, Long> delta = this.getDeltaValues(total, this.prevTotalFailedTaskCount);
            this.prevTotalFailedTaskCount = total;
            return delta;
        }
    }

    private Map<String, RowKey> getCurrentTaskDatasources() {
        return this.activeTasks.values().stream().filter(entry -> !entry.isComplete).map(entry -> entry.task).collect(Collectors.toMap(Task::getId, TaskQueue::getMetricKey));
    }

    public Map<RowKey, Long> getRunningTaskCount() {
        Map<String, RowKey> taskDatasources = this.getCurrentTaskDatasources();
        return this.taskRunner.getRunningTasks().stream().collect(Collectors.toMap(e -> taskDatasources.getOrDefault(e.getTaskId(), RowKey.empty()), e -> 1L, Long::sum));
    }

    public Map<RowKey, Long> getPendingTaskCount() {
        Map<String, RowKey> taskDatasources = this.getCurrentTaskDatasources();
        return this.taskRunner.getPendingTasks().stream().collect(Collectors.toMap(e -> taskDatasources.getOrDefault(e.getTaskId(), RowKey.empty()), e -> 1L, Long::sum));
    }

    public Map<RowKey, Long> getWaitingTaskCount() {
        Set runnerKnownTaskIds = this.taskRunner.getKnownTasks().stream().map(TaskRunnerWorkItem::getTaskId).collect(Collectors.toSet());
        return this.activeTasks.values().stream().filter(entry -> !entry.isComplete).map(entry -> entry.task).filter(task -> !runnerKnownTaskIds.contains(task.getId())).collect(Collectors.toMap(TaskQueue::getMetricKey, task -> 1L, Long::sum));
    }

    public Optional<TaskStatus> getTaskStatus(String taskId) {
        RunnerTaskState runnerTaskState = this.taskRunner.getRunnerTaskState(taskId);
        if (runnerTaskState != null && runnerTaskState != RunnerTaskState.NONE) {
            return Optional.of((Object)TaskStatus.running((String)taskId).withLocation(this.taskRunner.getTaskLocation(taskId)));
        }
        return this.taskStorage.getStatus(taskId);
    }

    public CoordinatorRunStats getQueueStats() {
        int queuedUpdates = this.statusUpdatesInQueue.get();
        int handledUpdates = this.handledStatusUpdates.getAndSet(0);
        if (queuedUpdates > 0) {
            log.info("There are [%d] task status updates in queue, handled [%d]", new Object[]{queuedUpdates, handledUpdates});
        }
        CoordinatorRunStats stats = new CoordinatorRunStats();
        stats.add(Stats.TaskQueue.STATUS_UPDATES_IN_QUEUE, (long)queuedUpdates);
        stats.add(Stats.TaskQueue.HANDLED_STATUS_UPDATES, (long)handledUpdates);
        return stats;
    }

    public Optional<Task> getActiveTask(String id) {
        TaskEntry entry = this.activeTasks.get(id);
        if (entry == null) {
            return Optional.absent();
        }
        Task task = entry.task;
        if (task != null) {
            try {
                task = (Task)this.passwordRedactingMapper.readValue(this.passwordRedactingMapper.writeValueAsString((Object)entry.task), Task.class);
            }
            catch (JsonProcessingException e) {
                log.error((Throwable)e, "Failed to serialize or deserialize task with id [%s].", new Object[]{task.getId()});
                throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build((Throwable)e, "Failed to serialize or deserialize task[%s].", new Object[]{task.getId()});
            }
        }
        return Optional.fromNullable((Object)task);
    }

    public List<Task> getTasks() {
        return this.activeTasks.values().stream().map(entry -> entry.task).collect(Collectors.toList());
    }

    public Map<String, Task> getActiveTasksForDatasource(String datasource) {
        return this.activeTasks.values().stream().filter(entry -> !entry.isComplete && entry.task.getDataSource().equals(datasource)).map(entry -> entry.task).collect(Collectors.toMap(Task::getId, Function.identity()));
    }

    private void emitTaskCompletionLogsAndMetrics(Task task, TaskStatus status) {
        if (status.isComplete()) {
            ServiceMetricEvent.Builder metricBuilder = ServiceMetricEvent.builder();
            IndexTaskUtils.setTaskDimensions(metricBuilder, task);
            IndexTaskUtils.setTaskStatusDimensions(metricBuilder, status);
            this.emitter.emit((ServiceEventBuilder)metricBuilder.setMetric("task/run/time", (Number)status.getDuration()));
            if (status.isSuccess()) {
                Counters.incrementAndGetLong(this.totalSuccessfulTaskCount, TaskQueue.getMetricKey(task));
            } else {
                Counters.incrementAndGetLong(this.totalFailedTaskCount, TaskQueue.getMetricKey(task));
            }
            log.info("Completed task[%s] with status[%s] in [%d]ms.", new Object[]{task.getId(), status, status.getDuration()});
        }
    }

    private void validateTaskPayload(Task task) {
        try {
            String payload = this.passwordRedactingMapper.writeValueAsString((Object)task);
            if (this.config.getMaxTaskPayloadSize() != null && this.config.getMaxTaskPayloadSize().getBytesInInt() < payload.length()) {
                throw InvalidInput.exception((String)"Task[%s] has payload of size[%d] but max allowed size is [%d]. Reduce the size of the task payload or increase 'druid.indexer.queue.maxTaskPayloadSize'.", (Object[])new Object[]{task.getId(), payload.length(), this.config.getMaxTaskPayloadSize()});
            }
            if ((long)payload.length() > 0x3C00000L) {
                log.warn("Task[%s] of datasource[%s] has payload size[%d] larger than the recommended maximum[%d]. Large task payloads may cause stability issues in the Overlord and may fail while persisting to the metadata store.Such tasks may be rejected by the Overlord in future Druid versions.", new Object[]{task.getId(), task.getDataSource(), payload.length(), 0x3C00000L});
            }
        }
        catch (JsonProcessingException e) {
            log.error((Throwable)e, "Failed to parse task payload for validation", new Object[0]);
            throw DruidException.defensive((String)"Failed to parse task payload for validation", (Object[])new Object[0]);
        }
    }

    private void updateTaskEntry(String taskId, Consumer<TaskEntry> updateOperation) {
        this.addOrUpdateTaskEntry(taskId, existingEntry -> {
            updateOperation.accept((TaskEntry)existingEntry);
            if (existingEntry != null) {
                existingEntry.lastUpdatedTime = DateTimes.nowUtc();
            }
            return existingEntry;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TaskEntry addOrUpdateTaskEntry(String taskId, Function<TaskEntry, TaskEntry> updateOperation) {
        this.startStopLock.readLock().lock();
        try {
            TaskEntry taskEntry = this.activeTasks.compute(taskId, (id, existingEntry) -> (TaskEntry)updateOperation.apply((TaskEntry)existingEntry));
            return taskEntry;
        }
        finally {
            this.startStopLock.readLock().unlock();
        }
    }

    private void removeTaskLock(Task task) {
        this.taskLockbox.remove(task);
    }

    private static RowKey getMetricKey(Task task) {
        if (task == null) {
            return RowKey.empty();
        }
        return RowKey.with((Dimension)Dimension.DATASOURCE, (String)task.getDataSource()).and(Dimension.TASK_TYPE, task.getType());
    }

    static class TaskEntry {
        private final Task task;
        private DateTime lastUpdatedTime;
        private ListenableFuture<TaskStatus> future = null;
        private boolean isComplete = false;

        TaskEntry(Task task) {
            this.task = task;
            this.lastUpdatedTime = DateTimes.nowUtc();
        }
    }
}

