/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.scheduledbatch;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.client.broker.BrokerClient;
import org.apache.druid.common.config.Configs;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.scheduledbatch.CronSchedulerConfig;
import org.apache.druid.indexing.scheduledbatch.ScheduledBatchSupervisor;
import org.apache.druid.indexing.scheduledbatch.ScheduledBatchTaskManager;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.explain.ExplainAttributes;
import org.apache.druid.query.explain.ExplainPlan;
import org.apache.druid.query.http.ClientSqlQuery;
import org.apache.druid.server.security.ResourceAction;

public class ScheduledBatchSupervisorSpec
implements SupervisorSpec {
    public static final String TYPE = "scheduled_batch";
    public static final String ID_PREFIX = "scheduled_batch__";
    private static final Logger log = new Logger(ScheduledBatchSupervisor.class);
    @JsonProperty
    private final ClientSqlQuery spec;
    @JsonProperty
    private final boolean suspended;
    @JsonProperty
    private final CronSchedulerConfig schedulerConfig;
    @JsonProperty
    private final String dataSource;
    @JsonProperty
    private final String id;
    private final ObjectMapper objectMapper;
    private final ScheduledBatchTaskManager batchTaskManager;
    private final BrokerClient brokerClient;

    @JsonCreator
    public ScheduledBatchSupervisorSpec(@JsonProperty(value="spec") ClientSqlQuery spec, @JsonProperty(value="schedulerConfig") CronSchedulerConfig schedulerConfig, @JsonProperty(value="suspended") @Nullable Boolean suspended, @JsonProperty(value="id") @Nullable String id, @JsonProperty(value="dataSource") @Nullable String dataSource, @JacksonInject ObjectMapper objectMapper, @JacksonInject ScheduledBatchTaskManager batchTaskManager, @JacksonInject BrokerClient brokerClient) {
        this.spec = spec;
        this.schedulerConfig = schedulerConfig;
        this.suspended = Configs.valueOrDefault((Boolean)suspended, (boolean)false);
        this.objectMapper = objectMapper;
        this.batchTaskManager = batchTaskManager;
        this.brokerClient = brokerClient;
        this.dataSource = dataSource != null ? dataSource : this.getDatasourceFromQuery();
        this.id = id != null ? id : ID_PREFIX + this.dataSource + "__" + String.valueOf(UUID.randomUUID());
    }

    private String getDatasourceFromQuery() {
        List explainPlanInfos;
        ListenableFuture explainPlanFuture = this.brokerClient.fetchExplainPlan(this.spec);
        try {
            explainPlanInfos = (List)explainPlanFuture.get();
        }
        catch (Exception e) {
            throw InvalidInput.exception((String)"Error getting datasource from query[%s]: [%s]", (Object[])new Object[]{this.spec, e});
        }
        if (explainPlanInfos.size() != 1) {
            throw DruidException.defensive((String)"Received an invalid EXPLAIN PLAN response for query[%s]. Expected a single plan information, but received[%d]: [%s].", (Object[])new Object[]{this.spec.getQuery(), explainPlanInfos.size(), explainPlanInfos});
        }
        ExplainAttributes explainAttributes = ((ExplainPlan)explainPlanInfos.get(0)).getAttributes();
        if ("SELECT".equalsIgnoreCase(explainAttributes.getStatementType())) {
            throw InvalidInput.exception((String)"SELECT queries are not supported by the [%s] supervisor. Only INSERT or REPLACE ingest queries are allowed.", (Object[])new Object[]{this.getType()});
        }
        return explainAttributes.getTargetDataSource();
    }

    public String getId() {
        return this.id;
    }

    public ScheduledBatchSupervisor createSupervisor() {
        return new ScheduledBatchSupervisor(this, this.batchTaskManager);
    }

    public List<String> getDataSources() {
        return Collections.singletonList(this.dataSource);
    }

    public ScheduledBatchSupervisorSpec createSuspendedSpec() {
        return new ScheduledBatchSupervisorSpec(this.spec, this.schedulerConfig, true, this.id, this.dataSource, this.objectMapper, this.batchTaskManager, null);
    }

    public ScheduledBatchSupervisorSpec createRunningSpec() {
        return new ScheduledBatchSupervisorSpec(this.spec, this.schedulerConfig, false, this.id, this.dataSource, this.objectMapper, this.batchTaskManager, null);
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public String getType() {
        return TYPE;
    }

    public String getSource() {
        return "";
    }

    @Nonnull
    public Set<ResourceAction> getInputSourceResources() throws UnsupportedOperationException {
        return Set.of();
    }

    public CronSchedulerConfig getSchedulerConfig() {
        return this.schedulerConfig;
    }

    public ClientSqlQuery getSpec() {
        return this.spec;
    }
}

