/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Map;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.KeyedDiff;
import org.apache.druid.java.util.metrics.MonitorUtils;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.Cpu;
import org.apache.druid.java.util.metrics.cgroups.ProcSelfCgroupDiscoverer;

public class CgroupCpuMonitor
extends FeedDefiningMonitor {
    private static final Logger LOG = new Logger(CgroupCpuMonitor.class);
    private static final Long DEFAULT_USER_HZ = 100L;
    final CgroupDiscoverer cgroupDiscoverer;
    final Map<String, String[]> dimensions;
    private Long userHz;
    private KeyedDiff jiffies = new KeyedDiff();
    private long prevJiffiesSnapshotAt = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CgroupCpuMonitor(CgroupDiscoverer cgroupDiscoverer, Map<String, String[]> dimensions, String feed) {
        super(feed);
        this.cgroupDiscoverer = cgroupDiscoverer;
        this.dimensions = dimensions;
        try {
            Process p = new ProcessBuilder("getconf", "CLK_TCK").start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
                String line = in.readLine();
                if (line != null) {
                    this.userHz = Long.valueOf(line.trim());
                }
            }
        }
        catch (IOException | NumberFormatException e) {
            LOG.warn(e, "Error getting the USER_HZ value", new Object[0]);
        }
        finally {
            if (this.userHz == null) {
                LOG.warn("Using default value for USER_HZ", new Object[0]);
                this.userHz = DEFAULT_USER_HZ;
            }
        }
    }

    public CgroupCpuMonitor(Map<String, String[]> dimensions, String feed) {
        this(new ProcSelfCgroupDiscoverer(), dimensions, feed);
    }

    public CgroupCpuMonitor(Map<String, String[]> dimensions) {
        this(dimensions, "metrics");
    }

    public CgroupCpuMonitor() {
        this((Map<String, String[]>)ImmutableMap.of());
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        Cpu cpu = new Cpu(this.cgroupDiscoverer);
        Cpu.CpuMetrics cpuSnapshot = cpu.snapshot();
        long now = Instant.now().getEpochSecond();
        ServiceMetricEvent.Builder builder = this.builder();
        MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
        emitter.emit(builder.setMetric("cgroup/cpu/shares", cpuSnapshot.getShares()));
        emitter.emit(builder.setMetric("cgroup/cpu/cores_quota", CgroupCpuMonitor.computeProcessorQuota(cpuSnapshot.getQuotaUs(), cpuSnapshot.getPeriodUs())));
        long elapsedJiffiesSnapshotSecs = now - this.prevJiffiesSnapshotAt;
        if (elapsedJiffiesSnapshotSecs > 0L) {
            this.prevJiffiesSnapshotAt = now;
            Map<String, Long> elapsedJiffies = this.jiffies.to("usage", (Map<String, Long>)ImmutableMap.builder().put((Object)"user", (Object)cpuSnapshot.getUserJiffies()).put((Object)"system", (Object)cpuSnapshot.getSystemJiffies()).put((Object)"total", (Object)cpuSnapshot.getTotalJiffies()).build());
            if (elapsedJiffies != null) {
                double totalUsagePct = 100.0 * (double)elapsedJiffies.get("total").longValue() / (double)this.userHz.longValue() / (double)elapsedJiffiesSnapshotSecs;
                double sysUsagePct = 100.0 * (double)elapsedJiffies.get("system").longValue() / (double)this.userHz.longValue() / (double)elapsedJiffiesSnapshotSecs;
                double userUsagePct = 100.0 * (double)elapsedJiffies.get("user").longValue() / (double)this.userHz.longValue() / (double)elapsedJiffiesSnapshotSecs;
                emitter.emit(builder.setMetric("cgroup/cpu/usage/total/percentage", totalUsagePct));
                emitter.emit(builder.setMetric("cgroup/cpu/usage/sys/percentage", sysUsagePct));
                emitter.emit(builder.setMetric("cgroup/cpu/usage/user/percentage", userUsagePct));
            }
        }
        return true;
    }

    public static double computeProcessorQuota(long quotaUs, long periodUs) {
        return quotaUs < 0L || periodUs == 0L ? -1.0 : (double)quotaUs / (double)periodUs;
    }
}

