/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.error.DruidException;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionProcessingException;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionValidationException;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.segment.column.Types;

public class FunctionErrorReportingExprVectorProcessor<T>
implements ExprVectorProcessor<T> {
    private final String functionName;
    private final ExprVectorProcessor<T> delegate;

    public FunctionErrorReportingExprVectorProcessor(String functionName, ExprVectorProcessor<T> delegate) {
        this.functionName = functionName;
        this.delegate = delegate;
    }

    @Override
    public ExprEvalVector<T> evalVector(Expr.VectorInputBinding bindings) {
        try {
            return this.delegate.evalVector(bindings);
        }
        catch (ExpressionProcessingException | ExpressionValidationException e) {
            throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build(e, e.getMessage(), new Object[0]);
        }
        catch (Types.InvalidCastBooleanException | Types.InvalidCastException e) {
            throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build(e, "Function[%s] encountered exception: %s", this.functionName, e.getMessage());
        }
        catch (DruidException e) {
            throw e;
        }
        catch (Exception e) {
            throw DruidException.defensive().build(e, "Function[%s] encountered unknown exception.", this.functionName);
        }
    }

    @Override
    public ExpressionType getOutputType() {
        return this.delegate.getOutputType();
    }

    @Override
    public int maxVectorSize() {
        return this.delegate.maxVectorSize();
    }
}

