/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorInputBindings;

public class ExpressionLambdaBufferAggregator
implements BufferAggregator {
    private static final short NOT_AGGREGATED_BIT = 128;
    private static final short IS_AGGREGATED_MASK = 63;
    private final Expr lambda;
    private final ExprEval<?> initialValue;
    private final ExpressionLambdaAggregatorInputBindings bindings;
    private final int maxSizeBytes;
    private final boolean isNullUnlessAggregated;
    private final boolean aggregateNullInputs;
    private final List<String> inputColumns;
    private final ExpressionType outputType;

    public ExpressionLambdaBufferAggregator(ExpressionLambdaAggregatorFactory.FactorizePlan thePlan, int maxSizeBytes) {
        this.lambda = thePlan.getExpression();
        this.initialValue = thePlan.getInitialValue();
        this.outputType = this.initialValue.type();
        this.bindings = thePlan.getBindings();
        this.isNullUnlessAggregated = thePlan.isNullUnlessAggregated();
        this.aggregateNullInputs = thePlan.shouldAggregateNullInputs();
        this.inputColumns = thePlan.getInputs();
        this.maxSizeBytes = maxSizeBytes;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        ExprEval.serialize(buf, position, this.outputType, this.initialValue, this.maxSizeBytes);
        if (this.isNullUnlessAggregated) {
            buf.put(position, (byte)(buf.get(position) | 0x80));
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        if (!this.aggregateNullInputs) {
            for (String column : this.inputColumns) {
                if (this.bindings.get(column) != null) continue;
                return;
            }
        }
        ExprEval<?> acc = ExprEval.deserialize(buf, position, this.maxSizeBytes, this.outputType, true);
        this.bindings.setAccumulator(acc);
        ExprEval newAcc = this.lambda.eval(this.bindings);
        ExprEval.serialize(buf, position, this.outputType, newAcc, this.maxSizeBytes);
        buf.put(position, (byte)(buf.get(position) & 0x3F));
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        if (this.isNullUnlessAggregated && (buf.get(position) & 0x80) != 0) {
            return null;
        }
        return ExprEval.deserialize(buf, position, this.maxSizeBytes, this.outputType, false).value();
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return (float)ExprEval.deserialize(buf, position, this.maxSizeBytes, this.outputType, true).asDouble();
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return ExprEval.deserialize(buf, position, this.maxSizeBytes, this.outputType, true).asDouble();
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return ExprEval.deserialize(buf, position, this.maxSizeBytes, this.outputType, true).asLong();
    }

    @Override
    public void close() {
    }
}

