/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.cardinality.types;

import com.google.common.hash.Hasher;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregator;
import org.apache.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.segment.BaseLongColumnValueSelector;

public class LongCardinalityAggregatorColumnSelectorStrategy
implements CardinalityAggregatorColumnSelectorStrategy<BaseLongColumnValueSelector> {
    public static void addLongToCollector(HyperLogLogCollector collector, long n) {
        collector.add(CardinalityAggregator.HASH_FUNCTION.hashLong(n).asBytes());
    }

    @Override
    public void hashRow(BaseLongColumnValueSelector selector, Hasher hasher) {
        if (!selector.isNull()) {
            hasher.putLong(selector.getLong());
        }
    }

    @Override
    public void hashValues(BaseLongColumnValueSelector selector, HyperLogLogCollector collector) {
        if (!selector.isNull()) {
            LongCardinalityAggregatorColumnSelectorStrategy.addLongToCollector(collector, selector.getLong());
        }
    }
}

