/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.VirtualizedColumnInspector;
import org.apache.druid.segment.virtual.VirtualizedColumnSelectorFactory;

public class VirtualColumns
implements Cacheable {
    public static final VirtualColumns EMPTY = new VirtualColumns((List<VirtualColumn>)ImmutableList.of(), (Map<String, VirtualColumn>)ImmutableMap.of(), (Map<String, VirtualColumn>)ImmutableMap.of());
    private final List<VirtualColumn> virtualColumns;
    private final List<String> virtualColumnNames;
    private final Supplier<Map<VirtualColumn.EquivalenceKey, VirtualColumn>> equivalence;
    private final Map<String, VirtualColumn> withDotSupport;
    private final Map<String, VirtualColumn> withoutDotSupport;
    private final boolean hasNoDotColumns;

    public static Pair<String, String> splitColumnName(String columnName) {
        int i = columnName.indexOf(46);
        if (i < 0) {
            return Pair.of(columnName, null);
        }
        return Pair.of(columnName.substring(0, i), columnName.substring(i + 1));
    }

    @JsonCreator
    public static VirtualColumns create(@Nullable List<VirtualColumn> virtualColumns) {
        if (virtualColumns == null || virtualColumns.isEmpty()) {
            return EMPTY;
        }
        return VirtualColumns.fromIterable(virtualColumns);
    }

    public static VirtualColumns create(VirtualColumn ... virtualColumns) {
        return VirtualColumns.create(Arrays.asList(virtualColumns));
    }

    public static VirtualColumns fromIterable(Iterable<VirtualColumn> virtualColumns) {
        HashMap<String, VirtualColumn> withDotSupport = new HashMap<String, VirtualColumn>();
        HashMap<String, VirtualColumn> withoutDotSupport = new HashMap<String, VirtualColumn>();
        for (VirtualColumn vc : virtualColumns) {
            if (Strings.isNullOrEmpty((String)vc.getOutputName())) {
                throw new IAE("Empty or null virtualColumn name", new Object[0]);
            }
            if (vc.getOutputName().equals("__time")) {
                throw new IAE("virtualColumn name[%s] not allowed", vc.getOutputName());
            }
            if (withDotSupport.containsKey(vc.getOutputName()) || withoutDotSupport.containsKey(vc.getOutputName())) {
                throw new IAE("Duplicate virtualColumn name[%s]", vc.getOutputName());
            }
            if (vc.usesDotNotation()) {
                withDotSupport.put(vc.getOutputName(), vc);
                continue;
            }
            withoutDotSupport.put(vc.getOutputName(), vc);
        }
        return new VirtualColumns((List<VirtualColumn>)ImmutableList.copyOf(virtualColumns), withDotSupport, withoutDotSupport);
    }

    public static VirtualColumns nullToEmpty(@Nullable VirtualColumns virtualColumns) {
        return virtualColumns == null ? EMPTY : virtualColumns;
    }

    private VirtualColumns(List<VirtualColumn> virtualColumns, Map<String, VirtualColumn> withDotSupport, Map<String, VirtualColumn> withoutDotSupport) {
        this.virtualColumns = virtualColumns;
        this.withDotSupport = withDotSupport;
        this.withoutDotSupport = withoutDotSupport;
        this.virtualColumnNames = new ArrayList<String>(virtualColumns.size());
        this.hasNoDotColumns = withDotSupport.isEmpty();
        for (VirtualColumn virtualColumn : virtualColumns) {
            this.detectCycles(virtualColumn, null);
            this.virtualColumnNames.add(virtualColumn.getOutputName());
        }
        this.equivalence = Suppliers.memoize(() -> {
            HashMap equiv = Maps.newHashMapWithExpectedSize((int)virtualColumns.size());
            for (VirtualColumn virtualColumn : virtualColumns) {
                VirtualColumn.EquivalenceKey key = virtualColumn.getEquivalanceKey();
                if (key == null) continue;
                equiv.putIfAbsent(key, virtualColumn);
            }
            return equiv;
        });
    }

    public boolean exists(String columnName) {
        return this.getVirtualColumn(columnName) != null;
    }

    @Nullable
    public VirtualColumn getVirtualColumn(String columnName) {
        VirtualColumn vc = this.withoutDotSupport.get(columnName);
        if (vc != null) {
            return vc;
        }
        if (this.hasNoDotColumns) {
            return null;
        }
        String baseColumnName = (String)VirtualColumns.splitColumnName((String)columnName).lhs;
        return this.withDotSupport.get(baseColumnName);
    }

    @Nullable
    public VirtualColumn findEquivalent(VirtualColumn virtualColumn) {
        return (VirtualColumn)((Map)this.equivalence.get()).get(virtualColumn.getEquivalanceKey());
    }

    @Nullable
    public ColumnIndexSupplier getIndexSupplier(String columnName, ColumnIndexSelector columnIndexSelector) {
        VirtualColumn virtualColumn = this.getVirtualColumnForSelector(columnName);
        return virtualColumn.getIndexSupplier(columnName, columnIndexSelector);
    }

    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory selectorFactory, @Nullable ColumnSelector columnSelector, @Nullable ReadableOffset offset) {
        VirtualColumn virtualColumn = this.getVirtualColumnForSelector(dimensionSpec.getDimension());
        DimensionSelector selector = virtualColumn.makeDimensionSelector(dimensionSpec, selectorFactory, columnSelector, offset);
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        return selector;
    }

    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory selectorFactory, @Nullable ColumnSelector columnSelector, @Nullable ReadableOffset offset) {
        VirtualColumn virtualColumn = this.getVirtualColumnForSelector(columnName);
        ColumnValueSelector<?> selector = virtualColumn.makeColumnValueSelector(columnName, selectorFactory, columnSelector, offset);
        Preconditions.checkNotNull(selector, (Object)"selector");
        return selector;
    }

    public boolean canVectorize(ColumnInspector columnInspector) {
        ColumnInspector inspector = this.wrapInspector(columnInspector);
        for (VirtualColumn virtualColumn : this.virtualColumns) {
            if (virtualColumn.canVectorize(inspector)) continue;
            return false;
        }
        return true;
    }

    public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(DimensionSpec dimensionSpec, VectorColumnSelectorFactory factory, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        VirtualColumn virtualColumn = this.getVirtualColumnForSelector(dimensionSpec.getDimension());
        SingleValueDimensionVectorSelector selector = virtualColumn.makeSingleValueVectorDimensionSelector(dimensionSpec, factory, columnSelector, offset);
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        return selector;
    }

    public MultiValueDimensionVectorSelector makeMultiValueDimensionVectorSelector(DimensionSpec dimensionSpec, VectorColumnSelectorFactory factory, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        VirtualColumn virtualColumn = this.getVirtualColumnForSelector(dimensionSpec.getDimension());
        MultiValueDimensionVectorSelector selector = virtualColumn.makeMultiValueVectorDimensionSelector(dimensionSpec, factory, columnSelector, offset);
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        return selector;
    }

    public VectorValueSelector makeVectorValueSelector(String columnName, VectorColumnSelectorFactory factory, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        VirtualColumn virtualColumn = this.getVirtualColumnForSelector(columnName);
        VectorValueSelector selector = virtualColumn.makeVectorValueSelector(columnName, factory, columnSelector, offset);
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        return selector;
    }

    public VectorObjectSelector makeVectorObjectSelector(String columnName, VectorColumnSelectorFactory factory, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        VirtualColumn virtualColumn = this.getVirtualColumnForSelector(columnName);
        VectorObjectSelector selector = virtualColumn.makeVectorObjectSelector(columnName, factory, columnSelector, offset);
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        return selector;
    }

    @Nullable
    ColumnCapabilities getColumnCapabilitiesWithoutFallback(ColumnInspector inspector, String columnName) {
        VirtualColumn virtualColumn = this.getVirtualColumn(columnName);
        if (virtualColumn != null) {
            return virtualColumn.capabilities(column -> this.getColumnCapabilitiesWithFallback(inspector, column), columnName);
        }
        return null;
    }

    @Nullable
    public ColumnCapabilities getColumnCapabilitiesWithFallback(ColumnInspector inspector, String columnName) {
        ColumnCapabilities virtualColumnCapabilities = this.getColumnCapabilitiesWithoutFallback(inspector, columnName);
        if (virtualColumnCapabilities != null) {
            return virtualColumnCapabilities;
        }
        return inspector.getColumnCapabilities(columnName);
    }

    @JsonValue
    public VirtualColumn[] getVirtualColumns() {
        return this.virtualColumns.toArray(new VirtualColumn[0]);
    }

    public ColumnSelectorFactory wrap(ColumnSelectorFactory baseFactory) {
        if (this.virtualColumns.isEmpty()) {
            return baseFactory;
        }
        return new VirtualizedColumnSelectorFactory(baseFactory, this);
    }

    public ColumnInspector wrapInspector(ColumnInspector inspector) {
        if (this.virtualColumns.isEmpty()) {
            return inspector;
        }
        return new VirtualizedColumnInspector(inspector, this);
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(0).appendCacheablesIgnoringOrder(this.virtualColumns).build();
    }

    public boolean isEmpty() {
        return this.virtualColumns.isEmpty();
    }

    public List<String> getColumnNames() {
        return this.virtualColumnNames;
    }

    private VirtualColumn getVirtualColumnForSelector(String columnName) {
        VirtualColumn virtualColumn = this.getVirtualColumn(columnName);
        if (virtualColumn == null) {
            throw new IAE("No such virtual column[%s]", columnName);
        }
        return virtualColumn;
    }

    private void detectCycles(VirtualColumn virtualColumn, @Nullable Set<String> visited) {
        HashSet visitedCopy = visited == null ? Sets.newHashSet((Object[])new String[]{virtualColumn.getOutputName()}) : Sets.newHashSet(visited);
        for (String columnName : virtualColumn.requiredColumns()) {
            VirtualColumn dependency = this.getVirtualColumn(columnName);
            if (dependency == null) continue;
            if (!visitedCopy.add(columnName)) {
                throw new IAE("Self-referential column[%s]", columnName);
            }
            this.detectCycles(dependency, visitedCopy);
            visitedCopy.remove(columnName);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualColumns that = (VirtualColumns)o;
        return this.virtualColumns.equals(that.virtualColumns);
    }

    public int hashCode() {
        return this.virtualColumns.hashCode();
    }

    public String toString() {
        return this.virtualColumns.toString();
    }

    public static class JsonIncludeFilter {
        public boolean equals(Object obj) {
            return obj instanceof VirtualColumns && ((VirtualColumns)obj).virtualColumns.isEmpty();
        }
    }
}

