/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.scheduledbatch;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.client.broker.BrokerClient;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerListener;
import org.apache.druid.indexing.scheduledbatch.BatchSupervisorTaskReport;
import org.apache.druid.indexing.scheduledbatch.CronSchedulerConfig;
import org.apache.druid.indexing.scheduledbatch.ScheduledBatchStatusTracker;
import org.apache.druid.indexing.scheduledbatch.ScheduledBatchSupervisor;
import org.apache.druid.indexing.scheduledbatch.ScheduledBatchSupervisorStatus;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.http.ClientSqlQuery;
import org.apache.druid.query.http.SqlTaskStatus;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class ScheduledBatchTaskManager {
    private static final Logger log = new EmittingLogger(ScheduledBatchTaskManager.class);
    private final TaskRunnerListener taskRunnerListener;
    private final TaskMaster taskMaster;
    private final ScheduledBatchStatusTracker statusTracker;
    private final BrokerClient brokerClient;
    private final ServiceEmitter emitter;
    private final ScheduledExecutorService tasksExecutor;
    private final ConcurrentHashMap<String, ScheduledBatchTask> supervisorToTaskScheduler = new ConcurrentHashMap();

    @Inject
    public ScheduledBatchTaskManager(TaskMaster taskMaster, ScheduledExecutorFactory executorFactory, BrokerClient brokerClient, ServiceEmitter emitter, final ScheduledBatchStatusTracker statusTracker) {
        this.taskMaster = taskMaster;
        this.brokerClient = brokerClient;
        this.emitter = emitter;
        this.statusTracker = statusTracker;
        this.tasksExecutor = executorFactory.create(1, "ScheduledBatchTaskManager-%s");
        this.taskRunnerListener = new TaskRunnerListener(){

            @Override
            public String getListenerId() {
                return "ScheduledBatchTaskManager";
            }

            @Override
            public void locationChanged(String taskId, TaskLocation newLocation) {
            }

            @Override
            public void statusChanged(String taskId, TaskStatus taskStatus) {
                if (taskStatus.isComplete()) {
                    statusTracker.onTaskCompleted(taskId, taskStatus);
                }
            }
        };
    }

    public void startScheduledIngestion(String supervisorId, String dataSource, CronSchedulerConfig cronSchedulerConfig, ClientSqlQuery spec) {
        log.info("Starting scheduled batch ingestion into datasource[%s] with supervisorId[%s], cronSchedule[%s] and spec[%s].", new Object[]{supervisorId, dataSource, cronSchedulerConfig, spec});
        ScheduledBatchTask taskScheduler = new ScheduledBatchTask(supervisorId, dataSource, cronSchedulerConfig, spec);
        taskScheduler.startScheduling();
        this.supervisorToTaskScheduler.put(supervisorId, taskScheduler);
    }

    public void stopScheduledIngestion(String supervisorId) {
        log.info("Stopping scheduled batch ingestion for supervisorId[%s].", new Object[]{supervisorId});
        ScheduledBatchTask taskScheduler = this.supervisorToTaskScheduler.get(supervisorId);
        if (taskScheduler != null) {
            taskScheduler.stopScheduling();
        }
    }

    public void start() {
        log.info("Starting scheduled batch task manager.", new Object[0]);
        Optional<TaskRunner> taskRunnerOptional = this.taskMaster.getTaskRunner();
        if (taskRunnerOptional.isPresent()) {
            ((TaskRunner)taskRunnerOptional.get()).registerListener(this.taskRunnerListener, (Executor)Execs.directExecutor());
        } else {
            log.warn("Task runner not registered for scheduled batch task manager.", new Object[0]);
        }
    }

    public void stop() {
        log.info("Stopping scheduled batch task manager.", new Object[0]);
        this.supervisorToTaskScheduler.forEach((supervisorId, taskScheduler) -> taskScheduler.stopScheduling());
        this.supervisorToTaskScheduler.clear();
        Optional<TaskRunner> taskRunnerOptional = this.taskMaster.getTaskRunner();
        if (taskRunnerOptional.isPresent()) {
            ((TaskRunner)taskRunnerOptional.get()).unregisterListener(this.taskRunnerListener.getListenerId());
        }
    }

    @Nullable
    public ScheduledBatchSupervisorStatus getSupervisorStatus(String supervisorId) {
        ScheduledBatchTask taskScheduler = this.supervisorToTaskScheduler.get(supervisorId);
        if (taskScheduler == null) {
            return null;
        }
        BatchSupervisorTaskReport taskReport = this.statusTracker.getSupervisorTaskReport(supervisorId);
        return new ScheduledBatchSupervisorStatus(supervisorId, taskScheduler.getState(), taskScheduler.getLastTaskSubmittedTime(), taskScheduler.getNextTaskSubmissionTime(), taskReport);
    }

    private void submitSqlTask(String supervisorId, ClientSqlQuery spec) throws ExecutionException, InterruptedException {
        SqlTaskStatus taskStatus = (SqlTaskStatus)FutureUtils.get((ListenableFuture)this.brokerClient.submitSqlTask(spec), (boolean)true);
        this.statusTracker.onTaskSubmitted(supervisorId, taskStatus);
        log.info("Submitted a new task[%s] for supervisor[%s].", new Object[]{taskStatus.getTaskId(), supervisorId});
    }

    private class ScheduledBatchTask {
        private final String supervisorId;
        private final String dataSource;
        private final ClientSqlQuery spec;
        private final CronSchedulerConfig cronSchedulerConfig;
        private ScheduledBatchSupervisor.State state;
        private volatile DateTime lastTaskSubmittedTime;

        private ScheduledBatchTask(String supervisorId, String dataSource, CronSchedulerConfig cronSchedulerConfig, ClientSqlQuery spec) {
            this.supervisorId = supervisorId;
            this.dataSource = dataSource;
            this.cronSchedulerConfig = cronSchedulerConfig;
            this.spec = spec;
        }

        private synchronized void startScheduling() {
            if (ScheduledBatchTaskManager.this.tasksExecutor.isTerminated() || ScheduledBatchTaskManager.this.tasksExecutor.isShutdown() || this.state == ScheduledBatchSupervisor.State.SUSPENDED) {
                return;
            }
            ScheduledBatchTaskManager.this.statusTracker.cleanupStaleTaskStatuses(this.supervisorId);
            this.state = ScheduledBatchSupervisor.State.RUNNING;
            Duration timeUntilNextSubmission = this.getTimeUntilNextTaskSubmission();
            if (timeUntilNextSubmission == null) {
                log.info("No more tasks will be submitted for supervisor[%s].", new Object[]{this.supervisorId});
                return;
            }
            log.info("Next task for supervisor[%s] will be scheduled after duration[%s].", new Object[]{this.supervisorId, timeUntilNextSubmission});
            ScheduledBatchTaskManager.this.tasksExecutor.schedule(() -> {
                try {
                    if (this.state == ScheduledBatchSupervisor.State.SUSPENDED) {
                        return;
                    }
                    ScheduledBatchTaskManager.this.submitSqlTask(this.supervisorId, this.spec);
                    this.lastTaskSubmittedTime = DateTimes.nowUtc();
                    this.emitMetric("task/scheduledBatch/submit/success", 1);
                }
                catch (Exception e) {
                    this.emitMetric("task/scheduledBatch/submit/failed", 1);
                    log.error((Throwable)e, "Error submitting task for supervisor[%s]. Continuing schedule.", new Object[]{this.supervisorId});
                }
                this.startScheduling();
            }, timeUntilNextSubmission.getMillis(), TimeUnit.MILLISECONDS);
        }

        private synchronized void stopScheduling() {
            this.state = ScheduledBatchSupervisor.State.SUSPENDED;
            ScheduledBatchTaskManager.this.statusTracker.cleanupStaleTaskStatuses(this.supervisorId);
        }

        private void emitMetric(String metricName, int value) {
            ScheduledBatchTaskManager.this.emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setDimension("id", (Object)this.supervisorId).setDimension("dataSource", (Object)this.dataSource).setMetric(metricName, (Number)value));
        }

        @Nullable
        private DateTime getLastTaskSubmittedTime() {
            return this.lastTaskSubmittedTime;
        }

        @Nullable
        private DateTime getNextTaskSubmissionTime() {
            return this.cronSchedulerConfig.getNextTaskStartTimeAfter(DateTimes.nowUtc());
        }

        @Nullable
        private Duration getTimeUntilNextTaskSubmission() {
            return this.cronSchedulerConfig.getDurationUntilNextTaskStartTimeAfter(DateTimes.nowUtc());
        }

        private ScheduledBatchSupervisor.State getState() {
            return this.state;
        }
    }
}

