/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1Capabilities;
import io.kubernetes.client.openapi.models.V1CapabilitiesBuilder;
import io.kubernetes.client.openapi.models.V1CapabilitiesFluentImpl;
import io.kubernetes.client.openapi.models.V1SELinuxOptions;
import io.kubernetes.client.openapi.models.V1SELinuxOptionsBuilder;
import io.kubernetes.client.openapi.models.V1SELinuxOptionsFluentImpl;
import io.kubernetes.client.openapi.models.V1SeccompProfile;
import io.kubernetes.client.openapi.models.V1SeccompProfileBuilder;
import io.kubernetes.client.openapi.models.V1SeccompProfileFluentImpl;
import io.kubernetes.client.openapi.models.V1SecurityContext;
import io.kubernetes.client.openapi.models.V1SecurityContextFluent;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptions;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptionsBuilder;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptionsFluentImpl;
import java.util.Objects;

public class V1SecurityContextFluentImpl<A extends V1SecurityContextFluent<A>>
extends BaseFluent<A>
implements V1SecurityContextFluent<A> {
    private Boolean allowPrivilegeEscalation;
    private V1CapabilitiesBuilder capabilities;
    private Boolean privileged;
    private String procMount;
    private Boolean readOnlyRootFilesystem;
    private Long runAsGroup;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private V1SELinuxOptionsBuilder seLinuxOptions;
    private V1SeccompProfileBuilder seccompProfile;
    private V1WindowsSecurityContextOptionsBuilder windowsOptions;

    public V1SecurityContextFluentImpl() {
    }

    public V1SecurityContextFluentImpl(V1SecurityContext instance) {
        if (instance != null) {
            this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
            this.withCapabilities(instance.getCapabilities());
            this.withPrivileged(instance.getPrivileged());
            this.withProcMount(instance.getProcMount());
            this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
            this.withRunAsGroup(instance.getRunAsGroup());
            this.withRunAsNonRoot(instance.getRunAsNonRoot());
            this.withRunAsUser(instance.getRunAsUser());
            this.withSeLinuxOptions(instance.getSeLinuxOptions());
            this.withSeccompProfile(instance.getSeccompProfile());
            this.withWindowsOptions(instance.getWindowsOptions());
        }
    }

    @Override
    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    @Override
    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return (A)this;
    }

    @Override
    public Boolean hasAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation != null;
    }

    @Override
    @Deprecated
    public V1Capabilities getCapabilities() {
        return this.capabilities != null ? this.capabilities.build() : null;
    }

    @Override
    public V1Capabilities buildCapabilities() {
        return this.capabilities != null ? this.capabilities.build() : null;
    }

    @Override
    public A withCapabilities(V1Capabilities capabilities) {
        this._visitables.get("capabilities").remove(this.capabilities);
        if (capabilities != null) {
            this.capabilities = new V1CapabilitiesBuilder(capabilities);
            this._visitables.get("capabilities").add(this.capabilities);
        } else {
            this.capabilities = null;
            this._visitables.get("capabilities").remove(this.capabilities);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCapabilities() {
        return this.capabilities != null;
    }

    @Override
    public V1SecurityContextFluent.CapabilitiesNested<A> withNewCapabilities() {
        return new CapabilitiesNestedImpl();
    }

    @Override
    public V1SecurityContextFluent.CapabilitiesNested<A> withNewCapabilitiesLike(V1Capabilities item) {
        return new CapabilitiesNestedImpl(item);
    }

    @Override
    public V1SecurityContextFluent.CapabilitiesNested<A> editCapabilities() {
        return this.withNewCapabilitiesLike(this.getCapabilities());
    }

    @Override
    public V1SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilities() {
        return this.withNewCapabilitiesLike(this.getCapabilities() != null ? this.getCapabilities() : new V1CapabilitiesBuilder().build());
    }

    @Override
    public V1SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilitiesLike(V1Capabilities item) {
        return this.withNewCapabilitiesLike(this.getCapabilities() != null ? this.getCapabilities() : item);
    }

    @Override
    public Boolean getPrivileged() {
        return this.privileged;
    }

    @Override
    public A withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return (A)this;
    }

    @Override
    public Boolean hasPrivileged() {
        return this.privileged != null;
    }

    @Override
    public String getProcMount() {
        return this.procMount;
    }

    @Override
    public A withProcMount(String procMount) {
        this.procMount = procMount;
        return (A)this;
    }

    @Override
    public Boolean hasProcMount() {
        return this.procMount != null;
    }

    @Override
    public Boolean getReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    @Override
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem != null;
    }

    @Override
    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    @Override
    public A withRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsGroup() {
        return this.runAsGroup != null;
    }

    @Override
    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    @Override
    public A withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsNonRoot() {
        return this.runAsNonRoot != null;
    }

    @Override
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    @Override
    public A withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    @Override
    @Deprecated
    public V1SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    @Override
    public V1SELinuxOptions buildSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    @Override
    public A withSeLinuxOptions(V1SELinuxOptions seLinuxOptions) {
        this._visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
        if (seLinuxOptions != null) {
            this.seLinuxOptions = new V1SELinuxOptionsBuilder(seLinuxOptions);
            this._visitables.get("seLinuxOptions").add(this.seLinuxOptions);
        } else {
            this.seLinuxOptions = null;
            this._visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeLinuxOptions() {
        return this.seLinuxOptions != null;
    }

    @Override
    public V1SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
        return new SeLinuxOptionsNestedImpl();
    }

    @Override
    public V1SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(V1SELinuxOptions item) {
        return new SeLinuxOptionsNestedImpl(item);
    }

    @Override
    public V1SecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions());
    }

    @Override
    public V1SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions() != null ? this.getSeLinuxOptions() : new V1SELinuxOptionsBuilder().build());
    }

    @Override
    public V1SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(V1SELinuxOptions item) {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions() != null ? this.getSeLinuxOptions() : item);
    }

    @Override
    @Deprecated
    public V1SeccompProfile getSeccompProfile() {
        return this.seccompProfile != null ? this.seccompProfile.build() : null;
    }

    @Override
    public V1SeccompProfile buildSeccompProfile() {
        return this.seccompProfile != null ? this.seccompProfile.build() : null;
    }

    @Override
    public A withSeccompProfile(V1SeccompProfile seccompProfile) {
        this._visitables.get("seccompProfile").remove(this.seccompProfile);
        if (seccompProfile != null) {
            this.seccompProfile = new V1SeccompProfileBuilder(seccompProfile);
            this._visitables.get("seccompProfile").add(this.seccompProfile);
        } else {
            this.seccompProfile = null;
            this._visitables.get("seccompProfile").remove(this.seccompProfile);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeccompProfile() {
        return this.seccompProfile != null;
    }

    @Override
    public V1SecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfile() {
        return new SeccompProfileNestedImpl();
    }

    @Override
    public V1SecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfileLike(V1SeccompProfile item) {
        return new SeccompProfileNestedImpl(item);
    }

    @Override
    public V1SecurityContextFluent.SeccompProfileNested<A> editSeccompProfile() {
        return this.withNewSeccompProfileLike(this.getSeccompProfile());
    }

    @Override
    public V1SecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfile() {
        return this.withNewSeccompProfileLike(this.getSeccompProfile() != null ? this.getSeccompProfile() : new V1SeccompProfileBuilder().build());
    }

    @Override
    public V1SecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfileLike(V1SeccompProfile item) {
        return this.withNewSeccompProfileLike(this.getSeccompProfile() != null ? this.getSeccompProfile() : item);
    }

    @Override
    @Deprecated
    public V1WindowsSecurityContextOptions getWindowsOptions() {
        return this.windowsOptions != null ? this.windowsOptions.build() : null;
    }

    @Override
    public V1WindowsSecurityContextOptions buildWindowsOptions() {
        return this.windowsOptions != null ? this.windowsOptions.build() : null;
    }

    @Override
    public A withWindowsOptions(V1WindowsSecurityContextOptions windowsOptions) {
        this._visitables.get("windowsOptions").remove(this.windowsOptions);
        if (windowsOptions != null) {
            this.windowsOptions = new V1WindowsSecurityContextOptionsBuilder(windowsOptions);
            this._visitables.get("windowsOptions").add(this.windowsOptions);
        } else {
            this.windowsOptions = null;
            this._visitables.get("windowsOptions").remove(this.windowsOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasWindowsOptions() {
        return this.windowsOptions != null;
    }

    @Override
    public V1SecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptions() {
        return new WindowsOptionsNestedImpl();
    }

    @Override
    public V1SecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptionsLike(V1WindowsSecurityContextOptions item) {
        return new WindowsOptionsNestedImpl(item);
    }

    @Override
    public V1SecurityContextFluent.WindowsOptionsNested<A> editWindowsOptions() {
        return this.withNewWindowsOptionsLike(this.getWindowsOptions());
    }

    @Override
    public V1SecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptions() {
        return this.withNewWindowsOptionsLike(this.getWindowsOptions() != null ? this.getWindowsOptions() : new V1WindowsSecurityContextOptionsBuilder().build());
    }

    @Override
    public V1SecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptionsLike(V1WindowsSecurityContextOptions item) {
        return this.withNewWindowsOptionsLike(this.getWindowsOptions() != null ? this.getWindowsOptions() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1SecurityContextFluentImpl that = (V1SecurityContextFluentImpl)o;
        if (!Objects.equals(this.allowPrivilegeEscalation, that.allowPrivilegeEscalation)) {
            return false;
        }
        if (!Objects.equals(this.capabilities, that.capabilities)) {
            return false;
        }
        if (!Objects.equals(this.privileged, that.privileged)) {
            return false;
        }
        if (!Objects.equals(this.procMount, that.procMount)) {
            return false;
        }
        if (!Objects.equals(this.readOnlyRootFilesystem, that.readOnlyRootFilesystem)) {
            return false;
        }
        if (!Objects.equals(this.runAsGroup, that.runAsGroup)) {
            return false;
        }
        if (!Objects.equals(this.runAsNonRoot, that.runAsNonRoot)) {
            return false;
        }
        if (!Objects.equals(this.runAsUser, that.runAsUser)) {
            return false;
        }
        if (!Objects.equals(this.seLinuxOptions, that.seLinuxOptions)) {
            return false;
        }
        if (!Objects.equals(this.seccompProfile, that.seccompProfile)) {
            return false;
        }
        return Objects.equals(this.windowsOptions, that.windowsOptions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowPrivilegeEscalation, this.capabilities, this.privileged, this.procMount, this.readOnlyRootFilesystem, this.runAsGroup, this.runAsNonRoot, this.runAsUser, this.seLinuxOptions, this.seccompProfile, this.windowsOptions, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowPrivilegeEscalation != null) {
            sb.append("allowPrivilegeEscalation:");
            sb.append(this.allowPrivilegeEscalation + ",");
        }
        if (this.capabilities != null) {
            sb.append("capabilities:");
            sb.append(this.capabilities + ",");
        }
        if (this.privileged != null) {
            sb.append("privileged:");
            sb.append(this.privileged + ",");
        }
        if (this.procMount != null) {
            sb.append("procMount:");
            sb.append(this.procMount + ",");
        }
        if (this.readOnlyRootFilesystem != null) {
            sb.append("readOnlyRootFilesystem:");
            sb.append(this.readOnlyRootFilesystem + ",");
        }
        if (this.runAsGroup != null) {
            sb.append("runAsGroup:");
            sb.append(this.runAsGroup + ",");
        }
        if (this.runAsNonRoot != null) {
            sb.append("runAsNonRoot:");
            sb.append(this.runAsNonRoot + ",");
        }
        if (this.runAsUser != null) {
            sb.append("runAsUser:");
            sb.append(this.runAsUser + ",");
        }
        if (this.seLinuxOptions != null) {
            sb.append("seLinuxOptions:");
            sb.append(this.seLinuxOptions + ",");
        }
        if (this.seccompProfile != null) {
            sb.append("seccompProfile:");
            sb.append(this.seccompProfile + ",");
        }
        if (this.windowsOptions != null) {
            sb.append("windowsOptions:");
            sb.append(this.windowsOptions);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withAllowPrivilegeEscalation() {
        return this.withAllowPrivilegeEscalation(true);
    }

    @Override
    public A withPrivileged() {
        return this.withPrivileged(true);
    }

    @Override
    public A withReadOnlyRootFilesystem() {
        return this.withReadOnlyRootFilesystem(true);
    }

    @Override
    public A withRunAsNonRoot() {
        return this.withRunAsNonRoot(true);
    }

    class CapabilitiesNestedImpl<N>
    extends V1CapabilitiesFluentImpl<V1SecurityContextFluent.CapabilitiesNested<N>>
    implements V1SecurityContextFluent.CapabilitiesNested<N>,
    Nested<N> {
        V1CapabilitiesBuilder builder;

        CapabilitiesNestedImpl(V1Capabilities item) {
            this.builder = new V1CapabilitiesBuilder(this, item);
        }

        CapabilitiesNestedImpl() {
            this.builder = new V1CapabilitiesBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1SecurityContextFluentImpl.this.withCapabilities(this.builder.build());
        }

        @Override
        public N endCapabilities() {
            return this.and();
        }
    }

    class SeLinuxOptionsNestedImpl<N>
    extends V1SELinuxOptionsFluentImpl<V1SecurityContextFluent.SeLinuxOptionsNested<N>>
    implements V1SecurityContextFluent.SeLinuxOptionsNested<N>,
    Nested<N> {
        V1SELinuxOptionsBuilder builder;

        SeLinuxOptionsNestedImpl(V1SELinuxOptions item) {
            this.builder = new V1SELinuxOptionsBuilder(this, item);
        }

        SeLinuxOptionsNestedImpl() {
            this.builder = new V1SELinuxOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1SecurityContextFluentImpl.this.withSeLinuxOptions(this.builder.build());
        }

        @Override
        public N endSeLinuxOptions() {
            return this.and();
        }
    }

    class SeccompProfileNestedImpl<N>
    extends V1SeccompProfileFluentImpl<V1SecurityContextFluent.SeccompProfileNested<N>>
    implements V1SecurityContextFluent.SeccompProfileNested<N>,
    Nested<N> {
        V1SeccompProfileBuilder builder;

        SeccompProfileNestedImpl(V1SeccompProfile item) {
            this.builder = new V1SeccompProfileBuilder(this, item);
        }

        SeccompProfileNestedImpl() {
            this.builder = new V1SeccompProfileBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1SecurityContextFluentImpl.this.withSeccompProfile(this.builder.build());
        }

        @Override
        public N endSeccompProfile() {
            return this.and();
        }
    }

    class WindowsOptionsNestedImpl<N>
    extends V1WindowsSecurityContextOptionsFluentImpl<V1SecurityContextFluent.WindowsOptionsNested<N>>
    implements V1SecurityContextFluent.WindowsOptionsNested<N>,
    Nested<N> {
        V1WindowsSecurityContextOptionsBuilder builder;

        WindowsOptionsNestedImpl(V1WindowsSecurityContextOptions item) {
            this.builder = new V1WindowsSecurityContextOptionsBuilder(this, item);
        }

        WindowsOptionsNestedImpl() {
            this.builder = new V1WindowsSecurityContextOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1SecurityContextFluentImpl.this.withWindowsOptions(this.builder.build());
        }

        @Override
        public N endWindowsOptions() {
            return this.and();
        }
    }
}

