/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.parquet.simple;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.data.input.parquet.simple.ParquetGroupConverter;
import org.apache.druid.java.util.common.parsers.FlattenerJsonProvider;
import org.apache.parquet.example.data.Group;

public class ParquetGroupJsonProvider
extends FlattenerJsonProvider {
    private final ParquetGroupConverter converter;

    public ParquetGroupJsonProvider(ParquetGroupConverter converter) {
        this.converter = converter;
    }

    public boolean isArray(Object o) {
        return o instanceof List;
    }

    public boolean isMap(Object o) {
        return o == null || o instanceof Map || o instanceof Group;
    }

    public int length(Object o) {
        if (o instanceof List) {
            return ((List)o).size();
        }
        if (o instanceof Group) {
            Group g = (Group)o;
            return g.getType().getFields().size();
        }
        return 0;
    }

    public Collection<String> getPropertyKeys(Object o) {
        if (o == null) {
            return Collections.emptySet();
        }
        if (o instanceof Map) {
            return ((Map)o).keySet().stream().map(String::valueOf).collect(Collectors.toSet());
        }
        if (o instanceof Group) {
            return ((Group)o).getType().getFields().stream().map(f -> f.getName()).collect(Collectors.toSet());
        }
        throw new UnsupportedOperationException(o.getClass().getName());
    }

    public Object getMapValue(Object o, String s) {
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            return ((Map)o).get(s);
        }
        if (o instanceof Group) {
            Group g = (Group)o;
            return this.converter.convertField(g, s);
        }
        throw new UnsupportedOperationException(o.getClass().getName());
    }
}

