/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.query.filter.DimFilter;
import org.joda.time.Interval;

@JsonTypeName(value="table")
public class TableInputSpec
implements InputSpec {
    private final String dataSource;
    private final List<Interval> intervals;
    @Nullable
    private final DimFilter filter;
    @Nullable
    private final Set<String> filterFields;

    @JsonCreator
    public TableInputSpec(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="intervals") @Nullable List<Interval> intervals, @JsonProperty(value="filter") @Nullable DimFilter filter, @JsonProperty(value="filterFields") @Nullable Set<String> filterFields) {
        this.dataSource = dataSource;
        this.intervals = intervals == null ? Intervals.ONLY_ETERNITY : intervals;
        this.filter = filter;
        this.filterFields = filterFields;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public List<Interval> getIntervals() {
        return this.intervals;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private List<Interval> getIntervalsForSerialization() {
        return this.intervals.equals(Intervals.ONLY_ETERNITY) ? null : this.intervals;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public DimFilter getFilter() {
        return this.filter;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Set<String> getFilterFields() {
        return this.filterFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableInputSpec that = (TableInputSpec)o;
        return Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.intervals, that.intervals) && Objects.equals(this.filter, that.filter) && Objects.equals(this.filterFields, that.filterFields);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.intervals, this.filter, this.filterFields);
    }

    public String toString() {
        return "TableInputSpec{dataSource='" + this.dataSource + "', intervals=" + String.valueOf(this.intervals) + (String)(this.filter == null ? "" : ", filter=" + String.valueOf(this.filter)) + (String)(this.filterFields == null ? "" : ", filterFields=" + String.valueOf(this.filterFields)) + "}";
    }
}

