/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.common;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameCursor;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Unit;

public class OffsetLimitFrameProcessor
implements FrameProcessor<Object> {
    private final ReadableFrameChannel inputChannel;
    private final WritableFrameChannel outputChannel;
    private final FrameReader frameReader;
    private final FrameWriterFactory frameWriterFactory;
    private final long offset;
    private final long limit;
    private final boolean inputSignatureMatchesOutputSignature;
    long rowsProcessedSoFar = 0L;

    OffsetLimitFrameProcessor(ReadableFrameChannel inputChannel, WritableFrameChannel outputChannel, FrameReader frameReader, FrameWriterFactory frameWriterFactory, long offset, long limit) {
        this.inputChannel = inputChannel;
        this.outputChannel = outputChannel;
        this.frameReader = frameReader;
        this.frameWriterFactory = frameWriterFactory;
        this.offset = offset;
        this.limit = limit;
        this.inputSignatureMatchesOutputSignature = frameReader.signature().equals((Object)frameWriterFactory.signature());
        if (offset < 0L || limit < 0L) {
            throw new ISE("Offset and limit must be nonnegative", new Object[0]);
        }
    }

    public List<ReadableFrameChannel> inputChannels() {
        return Collections.singletonList(this.inputChannel);
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList(this.outputChannel);
    }

    public ReturnOrAwait<Object> runIncrementally(IntSet readableInputs) throws IOException {
        if (readableInputs.isEmpty()) {
            return ReturnOrAwait.awaitAll((int)1);
        }
        if (this.inputChannel.isFinished() || this.rowsProcessedSoFar == this.offset + this.limit) {
            return ReturnOrAwait.returnObject((Object)Unit.instance());
        }
        Frame frame = this.inputChannel.read();
        Frame truncatedFrame = this.chopAndProcess(frame, this.frameReader);
        if (truncatedFrame != null) {
            this.outputChannel.write(new FrameWithPartition(truncatedFrame, -1));
        }
        if (this.rowsProcessedSoFar == this.offset + this.limit) {
            return ReturnOrAwait.returnObject((Object)Unit.instance());
        }
        assert (this.rowsProcessedSoFar < this.offset + this.limit);
        return ReturnOrAwait.awaitAll((int)1);
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), (Closeable[])new Closeable[0]);
    }

    @Nullable
    private Frame chopAndProcess(Frame frame, FrameReader frameReader) {
        long endRow;
        long startRow = Math.max(0L, this.offset - this.rowsProcessedSoFar);
        if (startRow >= (endRow = Math.min((long)frame.numRows(), this.offset + this.limit - this.rowsProcessedSoFar))) {
            this.rowsProcessedSoFar += (long)frame.numRows();
            return null;
        }
        if (startRow == 0L && endRow == (long)frame.numRows() && this.inputSignatureMatchesOutputSignature && this.frameWriterFactory.frameType().equals((Object)frame.type())) {
            this.rowsProcessedSoFar += (long)frame.numRows();
            return frame;
        }
        FrameCursor cursor = FrameProcessors.makeCursor((Frame)frame, (FrameReader)frameReader);
        try (FrameWriter frameWriter = this.frameWriterFactory.newFrameWriter(cursor.getColumnSelectorFactory());){
            long rowsProcessedSoFarInFrame;
            for (rowsProcessedSoFarInFrame = 0L; !cursor.isDone() && rowsProcessedSoFarInFrame < endRow; ++rowsProcessedSoFarInFrame) {
                if (rowsProcessedSoFarInFrame >= startRow && !frameWriter.addSelection()) {
                    throw new FrameRowTooLargeException(this.frameWriterFactory.allocatorCapacity());
                }
                cursor.advance();
            }
            this.rowsProcessedSoFar += rowsProcessedSoFarInFrame;
            Frame frame2 = Frame.wrap((byte[])frameWriter.toByteArray());
            return frame2;
        }
    }
}

