/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics.serde;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.msq.statistics.DelegateOrMinKeyCollectorSnapshot;
import org.apache.druid.msq.statistics.KeyCollectorSnapshot;
import org.apache.druid.msq.statistics.serde.KeyCollectorSnapshotSerializer;

public class DelegateOrMinSerializer
extends KeyCollectorSnapshotSerializer {
    public static final byte TYPE = 0;
    public static final byte ROWKEY_SNAPSHOT = 0;
    public static final byte SKETCH_SNAPSHOT = 1;

    @Override
    protected byte getType() {
        return 0;
    }

    @Override
    protected byte[] serializeKeyCollector(KeyCollectorSnapshot snapshot) {
        DelegateOrMinKeyCollectorSnapshot delegateOrMinKeySnapshot = (DelegateOrMinKeyCollectorSnapshot)snapshot;
        RowKey minKey = delegateOrMinKeySnapshot.getMinKey();
        if (minKey != null) {
            return ByteBuffer.allocate(5 + minKey.array().length).put((byte)0).putInt(minKey.array().length).put(minKey.array()).array();
        }
        Object delegateSnapshot = ((DelegateOrMinKeyCollectorSnapshot)Preconditions.checkNotNull((Object)((DelegateOrMinKeyCollectorSnapshot)snapshot))).getSnapshot();
        byte[] serializedSnapshot = delegateSnapshot.getSerializer().serialize((KeyCollectorSnapshot)delegateSnapshot);
        return ByteBuffer.allocate(5 + serializedSnapshot.length).put((byte)1).putInt(serializedSnapshot.length).put(serializedSnapshot).array();
    }
}

