/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.table.BaseInputSourceDefn;
import org.apache.druid.catalog.model.table.BaseTableFunction;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.FormattedInputSourceDefn;
import org.apache.druid.catalog.model.table.ResolvedExternalTable;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.utils.CollectionUtils;

public class InlineInputSourceDefn
extends FormattedInputSourceDefn {
    public static final String TYPE_KEY = "inline";
    public static final String DATA_PROPERTY = "data";
    public static final String DATA_FIELD = "data";

    @Override
    public String typeValue() {
        return TYPE_KEY;
    }

    @Override
    protected Class<? extends InputSource> inputSourceClass() {
        return InlineInputSource.class;
    }

    @Override
    protected List<TableFunction.ParameterDefn> adHocTableFnParameters() {
        return Collections.singletonList(new BaseTableFunction.Parameter("data", TableFunction.ParameterType.VARCHAR_ARRAY, false));
    }

    @Override
    public TableFunction partialTableFn(ResolvedExternalTable table) {
        return new BaseInputSourceDefn.PartialTableFunction(table, Collections.emptyList());
    }

    @Override
    public void validate(ResolvedExternalTable table) {
        if (table.inputFormatMap == null) {
            throw new IAE("An inline input source must provide a format.", new Object[0]);
        }
        if (CollectionUtils.isNullOrEmpty(table.resolvedTable().spec().columns())) {
            throw new IAE("An inline input source must provide one or more columns", new Object[0]);
        }
        super.validate(table);
    }

    @Override
    protected void convertArgsToSourceMap(Map<String, Object> jsonMap, Map<String, Object> args) {
        jsonMap.put("type", TYPE_KEY);
        List<String> data = CatalogUtils.getStringArray(args, "data");
        if (CollectionUtils.isNullOrEmpty(data)) {
            throw new IAE("An inline table requires one or more rows of data in the '%s' property", new Object[]{"data"});
        }
        jsonMap.put("data", String.join((CharSequence)"\n", data));
    }

    @Override
    protected ExternalTableSpec convertCompletedTable(ResolvedExternalTable table, Map<String, Object> args, List<ColumnSpec> columns) {
        if (!args.isEmpty()) {
            throw new ISE("Cannot provide arguments for an inline table", new Object[0]);
        }
        if (!CollectionUtils.isNullOrEmpty(columns)) {
            throw new IAE("Cannot provide columns for an inline table", new Object[0]);
        }
        return this.convertTable(table);
    }

    @Override
    protected void auditInputSource(Map<String, Object> jsonMap) {
        String data = CatalogUtils.getString(jsonMap, "data");
        if (data != null && !data.endsWith("\n")) {
            jsonMap.put("data", data + "\n");
        }
    }
}

