/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator.announcement;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.CreateBackgroundModeStatACLable;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.framework.api.SetDataBackgroundVersionable;
import org.apache.curator.framework.api.transaction.CuratorMultiTransaction;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.curator.announcement.Announceable;
import org.apache.druid.curator.announcement.ServiceAnnouncer;
import org.apache.druid.curator.cache.PathChildrenCacheFactory;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.utils.CloseableUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class PathChildrenAnnouncer
implements ServiceAnnouncer {
    private static final Logger log = new Logger(PathChildrenAnnouncer.class);
    private final CuratorFramework curator;
    private final PathChildrenCacheFactory factory;
    private final ExecutorService pathChildrenCacheExecutor;
    @GuardedBy(value="toAnnounce")
    private final List<Announceable> toAnnounce = new ArrayList<Announceable>();
    @GuardedBy(value="toAnnounce")
    private final List<Announceable> toUpdate = new ArrayList<Announceable>();
    private final ConcurrentHashMap<String, PathChildrenCache> listeners = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, byte[]>> announcements = new ConcurrentHashMap();
    private final List<String> parentsIBuilt = new CopyOnWriteArrayList<String>();
    private Set<String> addedChildren;
    private boolean started = false;

    public PathChildrenAnnouncer(CuratorFramework curator, ExecutorService exec) {
        this.curator = curator;
        this.pathChildrenCacheExecutor = exec;
        this.factory = new PathChildrenCacheFactory.Builder().withCacheData(false).withCompressed(true).withExecutorService(exec).withShutdownExecutorOnClose(false).build();
    }

    @VisibleForTesting
    void initializeAddedChildren() {
        this.addedChildren = new HashSet<String>();
    }

    @VisibleForTesting
    Set<String> getAddedChildren() {
        return this.addedChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStart
    public void start() {
        log.debug("Starting Announcer.", new Object[0]);
        List<Announceable> list = this.toAnnounce;
        synchronized (list) {
            if (this.started) {
                log.debug("Announcer has already been started by another thread, ignoring start request.", new Object[0]);
                return;
            }
            this.started = true;
            for (Announceable announceable : this.toAnnounce) {
                this.announce(announceable.path, announceable.bytes, announceable.removeParentsIfCreated);
            }
            this.toAnnounce.clear();
            for (Announceable announceable : this.toUpdate) {
                this.update(announceable.path, announceable.bytes);
            }
            this.toUpdate.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStop
    public void stop() {
        log.debug("Stopping Announcer.", new Object[0]);
        List<Announceable> list = this.toAnnounce;
        synchronized (list) {
            if (!this.started) {
                log.debug("Announcer has already been stopped by another thread, ignoring stop request.", new Object[0]);
                return;
            }
            this.started = false;
            try {
                CloseableUtils.closeAll(this.listeners.values());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.pathChildrenCacheExecutor.shutdown();
            }
            for (Map.Entry<String, ConcurrentHashMap<String, byte[]>> entry : this.announcements.entrySet()) {
                String basePath = entry.getKey();
                for (String announcementPath : entry.getValue().keySet()) {
                    this.unannounce(ZKPaths.makePath((String)basePath, (String)announcementPath));
                }
            }
            if (!this.parentsIBuilt.isEmpty()) {
                CuratorMultiTransaction transaction = this.curator.transaction();
                ArrayList<CuratorOp> operations = new ArrayList<CuratorOp>();
                for (String parent : this.parentsIBuilt) {
                    try {
                        operations.add((CuratorOp)this.curator.transactionOp().delete().forPath(parent));
                    }
                    catch (Exception e) {
                        log.info((Throwable)e, "Unable to delete parent[%s] when closing Announcer.", new Object[]{parent});
                    }
                }
                try {
                    transaction.forOperations(operations);
                }
                catch (Exception e) {
                    log.info((Throwable)e, "Unable to commit transaction when closing Announcer.", new Object[0]);
                }
            }
        }
    }

    @Override
    public void announce(String path, byte[] bytes) {
        this.announce(path, bytes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void announce(String path, byte[] bytes, boolean removeParentIfCreated) {
        Object object;
        List<Announceable> list = this.toAnnounce;
        synchronized (list) {
            if (!this.started) {
                log.debug("Announcer has not started yet, queuing announcement for later processing...", new Object[0]);
                this.toAnnounce.add(new Announceable(path, bytes, removeParentIfCreated));
                return;
            }
        }
        ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode((String)path);
        final String parentPath = pathAndNode.getPath();
        boolean buildParentPath = false;
        ConcurrentMap subPaths = this.announcements.get(parentPath);
        if (subPaths == null) {
            try {
                if (this.curator.checkExists().forPath(parentPath) == null) {
                    buildParentPath = true;
                }
            }
            catch (Exception e) {
                log.debug((Throwable)e, "Problem checking if the parent existed, ignoring.", new Object[0]);
            }
            final ConcurrentHashMap finalSubPaths = this.announcements.computeIfAbsent(parentPath, key -> new ConcurrentHashMap());
            object = finalSubPaths;
            synchronized (object) {
                if (!this.listeners.containsKey(parentPath)) {
                    PathChildrenCache cache = this.factory.make(this.curator, parentPath);
                    cache.getListenable().addListener((Object)new PathChildrenCacheListener(){
                        private final AtomicReference<Set<String>> pathsLost = new AtomicReference<Object>(null);

                        public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                            log.debug("Path[%s] got event[%s]", new Object[]{parentPath, event});
                            switch (event.getType()) {
                                case CHILD_REMOVED: {
                                    ChildData child = event.getData();
                                    ZKPaths.PathAndNode childPath = ZKPaths.getPathAndNode((String)child.getPath());
                                    byte[] value = (byte[])finalSubPaths.get(childPath.getNode());
                                    if (value == null) break;
                                    log.info("Node[%s] dropped, reinstating.", new Object[]{child.getPath()});
                                    PathChildrenAnnouncer.this.createAnnouncement(child.getPath(), value);
                                    break;
                                }
                                case CONNECTION_LOST: {
                                    HashSet<String> pathsToReinstate = new HashSet<String>();
                                    for (String node : finalSubPaths.keySet()) {
                                        String path = ZKPaths.makePath((String)parentPath, (String)node);
                                        log.info("Node[%s] is added to reinstate.", new Object[]{path});
                                        pathsToReinstate.add(path);
                                    }
                                    if (pathsToReinstate.isEmpty() || this.pathsLost.compareAndSet(null, pathsToReinstate)) break;
                                    log.info("Already had a pathsLost set!?[%s]", new Object[]{parentPath});
                                    break;
                                }
                                case CONNECTION_RECONNECTED: {
                                    Set thePathsLost = this.pathsLost.getAndSet(null);
                                    if (thePathsLost == null) break;
                                    for (String path : thePathsLost) {
                                        log.info("Reinstating [%s]", new Object[]{path});
                                        ZKPaths.PathAndNode split = ZKPaths.getPathAndNode((String)path);
                                        PathChildrenAnnouncer.this.createAnnouncement(path, PathChildrenAnnouncer.this.announcements.get(split.getPath()).get(split.getNode()));
                                    }
                                    break;
                                }
                                case CHILD_ADDED: {
                                    if (PathChildrenAnnouncer.this.addedChildren == null) break;
                                    PathChildrenAnnouncer.this.addedChildren.add(event.getData().getPath());
                                }
                            }
                        }
                    });
                    List<Announceable> list2 = this.toAnnounce;
                    synchronized (list2) {
                        if (this.started) {
                            if (buildParentPath) {
                                this.createPath(parentPath, removeParentIfCreated);
                            }
                            this.startCache(cache);
                            this.listeners.put(parentPath, cache);
                        }
                    }
                }
            }
            subPaths = finalSubPaths;
        }
        boolean created = false;
        object = this.toAnnounce;
        synchronized (object) {
            if (this.started) {
                byte[] oldBytes = subPaths.putIfAbsent(pathAndNode.getNode(), bytes);
                if (oldBytes == null) {
                    created = true;
                } else if (!Arrays.equals(oldBytes, bytes)) {
                    throw new IAE("Cannot reannounce different values under the same path", new Object[0]);
                }
            }
        }
        if (created) {
            try {
                this.createAnnouncement(path, bytes);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String path, byte[] bytes) {
        List<Announceable> list = this.toAnnounce;
        synchronized (list) {
            if (!this.started) {
                this.toUpdate.add(new Announceable(path, bytes));
                return;
            }
        }
        ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode((String)path);
        String parentPath = pathAndNode.getPath();
        String nodePath = pathAndNode.getNode();
        ConcurrentMap subPaths = this.announcements.get(parentPath);
        if (subPaths == null || subPaths.get(nodePath) == null) {
            throw new ISE("Cannot update path[%s] that hasn't been announced!", new Object[]{path});
        }
        List<Announceable> list2 = this.toAnnounce;
        synchronized (list2) {
            try {
                byte[] oldBytes = (byte[])subPaths.get(nodePath);
                if (!Arrays.equals(oldBytes, bytes)) {
                    subPaths.put(nodePath, bytes);
                    this.updateAnnouncement(path, bytes);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void createAnnouncement(String path, byte[] value) throws Exception {
        ((ErrorListenerPathAndBytesable)((ACLBackgroundPathAndBytesable)((CreateBackgroundModeStatACLable)this.curator.create().compressed()).withMode(CreateMode.EPHEMERAL)).inBackground()).forPath(path, value);
    }

    private void updateAnnouncement(String path, byte[] value) throws Exception {
        ((ErrorListenerPathAndBytesable)((SetDataBackgroundVersionable)this.curator.setData().compressed()).inBackground()).forPath(path, value);
    }

    @Override
    public void unannounce(String path) {
        ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode((String)path);
        String parentPath = pathAndNode.getPath();
        ConcurrentMap subPaths = this.announcements.get(parentPath);
        if (subPaths == null || subPaths.remove(pathAndNode.getNode()) == null) {
            log.debug("Path[%s] not announced, cannot unannounce.", new Object[]{path});
            return;
        }
        log.info("Unannouncing [%s]", new Object[]{path});
        try {
            CuratorOp deleteOp = (CuratorOp)this.curator.transactionOp().delete().forPath(path);
            this.curator.transaction().forOperations(new CuratorOp[]{deleteOp});
        }
        catch (KeeperException.NoNodeException e) {
            log.info("Unannounced node[%s] that does not exist.", new Object[]{path});
        }
        catch (KeeperException.NotEmptyException e) {
            log.warn("Unannouncing non-empty path[%s]", new Object[]{path});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void startCache(PathChildrenCache cache) {
        try {
            cache.start();
        }
        catch (Throwable e) {
            throw CloseableUtils.closeAndWrapInCatch((Throwable)e, (Closeable)cache);
        }
    }

    private void createPath(String parentPath, boolean removeParentsIfCreated) {
        try {
            this.curator.create().creatingParentsIfNeeded().forPath(parentPath);
            if (removeParentsIfCreated) {
                this.parentsIBuilt.add(parentPath);
            }
            log.debug("Created parentPath[%s], %s remove on stop.", new Object[]{parentPath, removeParentsIfCreated ? "will" : "will not"});
        }
        catch (KeeperException.NodeExistsException e) {
            log.info((Throwable)e, "Problem creating parentPath[%s], someone else created it first?", new Object[]{parentPath});
        }
        catch (Exception e) {
            log.error((Throwable)e, "Unhandled exception when creating parentPath[%s].", new Object[]{parentPath});
        }
    }
}

