/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.apache.druid.timeline.partition.OverwriteShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;

public final class SegmentPublisherHelper {
    private static final Logger LOG = new Logger(SegmentPublisherHelper.class);

    static Set<DataSegment> annotateShardSpec(Set<DataSegment> segments) {
        HashMap intervalToSegments = new HashMap();
        segments.forEach(segment -> intervalToSegments.computeIfAbsent(segment.getInterval(), k -> new ArrayList()).add(segment));
        for (Map.Entry entry : intervalToSegments.entrySet()) {
            Function<DataSegment, DataSegment> annotateFn;
            Interval interval = (Interval)entry.getKey();
            List segmentsPerInterval = (List)entry.getValue();
            ShardSpec firstShardSpec = ((DataSegment)segmentsPerInterval.get(0)).getShardSpec();
            boolean anyMismatch = segmentsPerInterval.stream().anyMatch(segment -> segment.getShardSpec().getClass() != firstShardSpec.getClass());
            if (anyMismatch) {
                throw new ISE("Mismatched shardSpecs in interval[%s] for segments[%s]", new Object[]{interval, segmentsPerInterval});
            }
            if (firstShardSpec instanceof OverwriteShardSpec) {
                annotateFn = SegmentPublisherHelper.annotateAtomicUpdateGroupFn(segmentsPerInterval.size());
            } else if (firstShardSpec instanceof BuildingShardSpec) {
                int actualCorePartitionSetSize;
                int expectedCorePartitionSetSize = segmentsPerInterval.size();
                if (expectedCorePartitionSetSize != (actualCorePartitionSetSize = Math.toIntExact(segmentsPerInterval.stream().filter(segment -> segment.getShardSpec().getPartitionNum() < expectedCorePartitionSetSize).count()))) {
                    LOG.errorSegments((Collection)segmentsPerInterval, "Cannot publish segments due to incomplete time chunk");
                    throw new ISE("Cannot publish segments due to incomplete time chunk for interval[%s]. Expected [%s] segments in the core partition, but only [%] segments are found. See task logs for more details about these segments.", new Object[]{interval, expectedCorePartitionSetSize, actualCorePartitionSetSize});
                }
                annotateFn = SegmentPublisherHelper.annotateCorePartitionSetSizeFn(expectedCorePartitionSetSize);
            } else {
                if (firstShardSpec instanceof BucketNumberedShardSpec) {
                    throw new ISE("Cannot publish segments with shardSpec[%s]", new Object[]{firstShardSpec});
                }
                annotateFn = null;
            }
            if (annotateFn == null) continue;
            intervalToSegments.put(interval, segmentsPerInterval.stream().map(annotateFn).collect(Collectors.toList()));
        }
        return intervalToSegments.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Function<DataSegment, DataSegment> annotateAtomicUpdateGroupFn(int atomicUpdateGroupSize) {
        return segment -> {
            OverwriteShardSpec shardSpec = (OverwriteShardSpec)segment.getShardSpec();
            return segment.withShardSpec((ShardSpec)shardSpec.withAtomicUpdateGroupSize((short)atomicUpdateGroupSize));
        };
    }

    private static Function<DataSegment, DataSegment> annotateCorePartitionSetSizeFn(int corePartitionSetSize) {
        return segment -> {
            BuildingShardSpec shardSpec = (BuildingShardSpec)segment.getShardSpec();
            return segment.withShardSpec(shardSpec.convert(corePartitionSetSize));
        };
    }

    private SegmentPublisherHelper() {
    }
}

