/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.curator.announcement.ServiceAnnouncer;
import org.apache.druid.guice.annotations.SingleThreadedAnnouncer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.initialization.ZkPathsConfig;

@Deprecated
public class CuratorDataSegmentServerAnnouncer
implements DataSegmentServerAnnouncer {
    private static final Logger log = new Logger(CuratorDataSegmentServerAnnouncer.class);
    private final DruidServerMetadata server;
    private final ZkPathsConfig config;
    private final ServiceAnnouncer announcer;
    private final ObjectMapper jsonMapper;
    private final Object lock = new Object();
    private volatile boolean announced = false;

    @Inject
    public CuratorDataSegmentServerAnnouncer(DruidServerMetadata server, ZkPathsConfig config, @SingleThreadedAnnouncer ServiceAnnouncer announcer, ObjectMapper jsonMapper) {
        this.server = server;
        this.config = config;
        this.announcer = announcer;
        this.jsonMapper = jsonMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void announce() {
        Object object = this.lock;
        synchronized (object) {
            if (this.announced) {
                return;
            }
            try {
                String path = this.makeAnnouncementPath();
                log.info("Announcing self[%s] at [%s]", new Object[]{this.server, path});
                this.announcer.announce(path, this.jsonMapper.writeValueAsBytes((Object)this.server), false);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            this.announced = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unannounce() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.announced) {
                return;
            }
            String path = this.makeAnnouncementPath();
            log.debug("Unannouncing self[%s] at [%s]", new Object[]{this.server, path});
            this.announcer.unannounce(path);
            this.announced = false;
        }
    }

    private String makeAnnouncementPath() {
        return ZKPaths.makePath((String)this.config.getAnnouncementsPath(), (String)this.server.getName());
    }
}

