/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.balancer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.balancer.BalancerSegmentHolder;
import org.apache.druid.server.coordinator.loading.SegmentAction;
import org.apache.druid.timeline.DataSegment;

public final class ReservoirSegmentSampler {
    private static final EmittingLogger log = new EmittingLogger(ReservoirSegmentSampler.class);

    public static List<BalancerSegmentHolder> pickMovableSegmentsFrom(List<ServerHolder> serverHolders, int maxSegmentsToPick, Function<ServerHolder, Collection<DataSegment>> segmentProvider, Set<String> broadcastDatasources) {
        if (maxSegmentsToPick == 0 || serverHolders.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BalancerSegmentHolder> pickedSegments = new ArrayList<BalancerSegmentHolder>(maxSegmentsToPick);
        int numSoFar = 0;
        for (ServerHolder server : serverHolders) {
            if (!server.getServer().getType().isSegmentReplicationTarget()) continue;
            Collection<DataSegment> movableSegments = segmentProvider.apply(server);
            for (DataSegment segment : movableSegments) {
                if (broadcastDatasources.contains(segment.getDataSource()) || server.getActionOnSegment(segment) == SegmentAction.MOVE_FROM) continue;
                if (numSoFar < maxSegmentsToPick) {
                    pickedSegments.add(new BalancerSegmentHolder(server, segment));
                    ++numSoFar;
                    continue;
                }
                int randNum = ThreadLocalRandom.current().nextInt(numSoFar + 1);
                if (randNum < maxSegmentsToPick) {
                    pickedSegments.set(randNum, new BalancerSegmentHolder(server, segment));
                }
                ++numSoFar;
            }
        }
        return pickedSegments;
    }

    @Deprecated
    static BalancerSegmentHolder getRandomBalancerSegmentHolder(List<ServerHolder> serverHolders, Set<String> broadcastDatasources, double percentOfSegmentsToConsider) {
        ServerHolder fromServerHolder = null;
        DataSegment proposalSegment = null;
        int calculatedSegmentLimit = Integer.MAX_VALUE;
        int numSoFar = 0;
        if (percentOfSegmentsToConsider <= 0.0 || percentOfSegmentsToConsider > 100.0) {
            log.warn("Resetting percentOfSegmentsToConsider to 100 because only values from 1 to 100 are allowed. You Provided [%f]", new Object[]{percentOfSegmentsToConsider});
            percentOfSegmentsToConsider = 100.0;
        }
        if (percentOfSegmentsToConsider < 100.0) {
            int totalSegments = 0;
            for (ServerHolder server : serverHolders) {
                totalSegments += server.getServer().getNumSegments();
            }
            if (totalSegments != 0) {
                calculatedSegmentLimit = (int)Math.ceil((double)totalSegments * (percentOfSegmentsToConsider / 100.0));
            } else {
                log.warn("Unable to calculate limit on segments to consider because ServerHolder collection indicates zero segments existing in the cluster.", new Object[0]);
            }
        }
        for (ServerHolder server : serverHolders) {
            if (!server.getServer().getType().isSegmentReplicationTarget()) continue;
            for (DataSegment segment : server.getServer().iterateAllSegments()) {
                if (broadcastDatasources.contains(segment.getDataSource())) continue;
                int randNum = ThreadLocalRandom.current().nextInt(numSoFar + 1);
                if (randNum == numSoFar) {
                    fromServerHolder = server;
                    proposalSegment = segment;
                }
                if (!(percentOfSegmentsToConsider < 100.0) || ++numSoFar < calculatedSegmentLimit) continue;
                log.debug("Breaking out of iteration over potential segments to move because we hit the limit [%f percent] of segments to consider to move. Segments Iterated: [%d]", new Object[]{percentOfSegmentsToConsider, numSoFar});
                break;
            }
            if (!(percentOfSegmentsToConsider < 100.0) || numSoFar < calculatedSegmentLimit) continue;
            break;
        }
        if (fromServerHolder != null) {
            return new BalancerSegmentHolder(fromServerHolder, proposalSegment);
        }
        return null;
    }

    private ReservoirSegmentSampler() {
    }
}

