/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.emitter;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.core.ComposingEmitter;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.server.emitter.ComposingEmitterConfig;

public class ComposingEmitterModule
implements DruidModule {
    private static Logger log = new Logger(ComposingEmitterModule.class);

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.emitter.composing", ComposingEmitterConfig.class);
    }

    @Provides
    @ManageLifecycle
    @Named(value="composing")
    public Emitter getEmitter(ComposingEmitterConfig config, final Injector injector) {
        log.info("Creating Composing Emitter with %s", new Object[]{config.getEmitters()});
        List emitters = Lists.transform(config.getEmitters(), (Function)new Function<String, Emitter>(){

            public Emitter apply(String s) {
                return (Emitter)injector.getInstance(Key.get(Emitter.class, (Annotation)Names.named((String)s)));
            }
        });
        return new ComposingEmitter(emitters);
    }
}

