/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Map;
import java.util.Set;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.server.metrics.IndexerTaskCountStatsProvider;
import org.apache.druid.server.metrics.WorkerTaskCountStatsProvider;

@LoadScope(roles={"indexer", "middleManager"})
public class WorkerTaskCountStatsMonitor
extends AbstractMonitor {
    private final WorkerTaskCountStatsProvider statsProvider;
    private final IndexerTaskCountStatsProvider indexerStatsProvider;
    private final String workerCategory;
    private final String workerVersion;
    private final boolean isMiddleManager;
    private final boolean isIndexer;

    @Inject
    public WorkerTaskCountStatsMonitor(Injector injector, @Self Set<NodeRole> nodeRoles) {
        this.isMiddleManager = nodeRoles.contains(NodeRole.MIDDLE_MANAGER);
        this.isIndexer = nodeRoles.contains(NodeRole.INDEXER);
        if (this.isMiddleManager) {
            this.statsProvider = (WorkerTaskCountStatsProvider)injector.getInstance(WorkerTaskCountStatsProvider.class);
            this.indexerStatsProvider = null;
            this.workerCategory = this.statsProvider.getWorkerCategory();
            this.workerVersion = this.statsProvider.getWorkerVersion();
        } else if (this.isIndexer) {
            this.indexerStatsProvider = (IndexerTaskCountStatsProvider)injector.getInstance(IndexerTaskCountStatsProvider.class);
            this.statsProvider = null;
            this.workerCategory = null;
            this.workerVersion = null;
        } else {
            this.indexerStatsProvider = null;
            this.statsProvider = null;
            this.workerCategory = null;
            this.workerVersion = null;
        }
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        if (this.isMiddleManager) {
            this.emit(emitter, "worker/task/failed/count", this.statsProvider.getWorkerFailedTaskCount());
            this.emit(emitter, "worker/task/success/count", this.statsProvider.getWorkerSuccessfulTaskCount());
            this.emit(emitter, "worker/taskSlot/idle/count", this.statsProvider.getWorkerIdleTaskSlotCount());
            this.emit(emitter, "worker/taskSlot/total/count", this.statsProvider.getWorkerTotalTaskSlotCount());
            this.emit(emitter, "worker/taskSlot/used/count", this.statsProvider.getWorkerUsedTaskSlotCount());
        } else if (this.isIndexer) {
            this.emit(emitter, "worker/task/running/count", this.indexerStatsProvider.getWorkerRunningTasks());
            this.emit(emitter, "worker/task/assigned/count", this.indexerStatsProvider.getWorkerAssignedTasks());
            this.emit(emitter, "worker/task/completed/count", this.indexerStatsProvider.getWorkerCompletedTasks());
            this.emit(emitter, "worker/task/failed/count", this.indexerStatsProvider.getWorkerFailedTasks());
            this.emit(emitter, "worker/task/success/count", this.indexerStatsProvider.getWorkerSuccessfulTasks());
        }
        return true;
    }

    private void emit(ServiceEmitter emitter, String metricName, Long value) {
        if (value != null) {
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
            builder.setDimension("category", (Object)this.workerCategory);
            builder.setDimension("workerVersion", (Object)this.workerVersion);
            emitter.emit((ServiceEventBuilder)builder.setMetric(metricName, (Number)value));
        }
    }

    public void emit(ServiceEmitter emitter, String metricName, Map<String, Long> dataSourceTaskMap) {
        for (Map.Entry<String, Long> dataSourceTaskCount : dataSourceTaskMap.entrySet()) {
            if (dataSourceTaskCount.getValue() == null) continue;
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
            builder.setDimension("dataSource", (Object)dataSourceTaskCount.getKey());
            emitter.emit((ServiceEventBuilder)builder.setMetric(metricName, (Number)dataSourceTaskCount.getValue()));
        }
    }
}

