/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.external;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.catalog.model.table.BaseTableFunction;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.external.DruidExternTableMacroConversion;

public class ExternalOperatorConversion
extends DruidExternTableMacroConversion {
    public static final String FUNCTION_NAME = "EXTERN";
    public static final String INPUT_SOURCE_PARAM = "inputSource";
    public static final String INPUT_FORMAT_PARAM = "inputFormat";
    public static final String SIGNATURE_PARAM = "signature";

    private static DruidException badArgumentException(Throwable cause, String fieldName) {
        return InvalidInput.exception((Throwable)cause, (String)"Invalid value for the field [%s]. Reason: [%s]", (Object[])new Object[]{fieldName, cause.getMessage()});
    }

    @Inject
    public ExternalOperatorConversion(@Json ObjectMapper jsonMapper) {
        super(FUNCTION_NAME, (TableFunction)new ExternFunction(), jsonMapper);
    }

    private static class ExternFunction
    extends BaseTableFunction {
        public ExternFunction() {
            super(Arrays.asList(new BaseTableFunction.Parameter(ExternalOperatorConversion.INPUT_SOURCE_PARAM, TableFunction.ParameterType.VARCHAR, false), new BaseTableFunction.Parameter(ExternalOperatorConversion.INPUT_FORMAT_PARAM, TableFunction.ParameterType.VARCHAR, false), new BaseTableFunction.Parameter(ExternalOperatorConversion.SIGNATURE_PARAM, TableFunction.ParameterType.VARCHAR, true)));
        }

        public ExternalTableSpec apply(String fnName, Map<String, Object> args, List<ColumnSpec> columns, ObjectMapper jsonMapper) {
            InputFormat inputFormat;
            InputSource inputSource;
            RowSignature rowSignature;
            String sigValue = CatalogUtils.getString(args, (String)ExternalOperatorConversion.SIGNATURE_PARAM);
            if (sigValue == null && columns == null) {
                throw InvalidInput.exception((String)"EXTERN requires either a [%s] value or an EXTEND clause", (Object[])new Object[]{ExternalOperatorConversion.SIGNATURE_PARAM});
            }
            if (sigValue != null && columns != null) {
                throw InvalidInput.exception((String)"EXTERN requires either a [%s] value or an EXTEND clause, but not both", (Object[])new Object[]{ExternalOperatorConversion.SIGNATURE_PARAM});
            }
            if (columns != null) {
                try {
                    rowSignature = Columns.convertSignature(columns);
                }
                catch (IAE e) {
                    throw ExternalOperatorConversion.badArgumentException(e, "columns");
                }
            }
            try {
                rowSignature = (RowSignature)jsonMapper.readValue(sigValue, RowSignature.class);
            }
            catch (JsonProcessingException e) {
                throw ExternalOperatorConversion.badArgumentException(e, "rowSignature");
            }
            String inputSrcStr = CatalogUtils.getString(args, (String)ExternalOperatorConversion.INPUT_SOURCE_PARAM);
            try {
                inputSource = (InputSource)jsonMapper.readValue(inputSrcStr, InputSource.class);
            }
            catch (JsonProcessingException e) {
                throw ExternalOperatorConversion.badArgumentException(e, ExternalOperatorConversion.INPUT_SOURCE_PARAM);
            }
            try {
                inputFormat = (InputFormat)jsonMapper.readValue(CatalogUtils.getString(args, (String)ExternalOperatorConversion.INPUT_FORMAT_PARAM), InputFormat.class);
            }
            catch (JsonProcessingException e) {
                throw ExternalOperatorConversion.badArgumentException(e, ExternalOperatorConversion.INPUT_FORMAT_PARAM);
            }
            return new ExternalTableSpec(inputSource, inputFormat, rowSignature, () -> ((InputSource)inputSource).getTypes());
        }
    }
}

