/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.protobuf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.protobuf.DescriptorProtos;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.apache.druid.data.input.protobuf.DescriptorBasedProtobufBytesDecoder;
import org.apache.druid.java.util.common.parsers.ParseException;

public class FileBasedProtobufBytesDecoder
extends DescriptorBasedProtobufBytesDecoder {
    private final String descriptorFilePath;

    @JsonCreator
    public FileBasedProtobufBytesDecoder(@JsonProperty(value="descriptor") String descriptorFilePath, @JsonProperty(value="protoMessageType") String protoMessageType) {
        super(protoMessageType);
        Preconditions.checkNotNull((Object)descriptorFilePath);
        this.descriptorFilePath = descriptorFilePath;
        this.initializeDescriptor();
    }

    @JsonProperty(value="descriptor")
    public String getDescriptorFilePath() {
        return this.descriptorFilePath;
    }

    @Override
    protected DescriptorProtos.FileDescriptorSet loadFileDescriptorSet() {
        try {
            DescriptorProtos.FileDescriptorSet descriptorSet;
            InputStream fin = this.getClass().getClassLoader().getResourceAsStream(this.descriptorFilePath);
            if (fin == null) {
                URL url;
                try {
                    url = new URL(this.descriptorFilePath);
                }
                catch (MalformedURLException e) {
                    throw new ParseException(this.descriptorFilePath, (Throwable)e, "Descriptor not found in class path or malformed URL: [%s]", new Object[]{this.descriptorFilePath});
                }
                try (InputStream urlIn = url.openConnection().getInputStream();){
                    if (urlIn == null) {
                        throw new ParseException(this.descriptorFilePath, "Descriptor not found at URL: [%s]", new Object[]{this.descriptorFilePath});
                    }
                    descriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom(urlIn);
                }
            }
            descriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom(fin);
            if (descriptorSet.getFileCount() == 0) {
                throw new ParseException(null, "No file descriptors found in the descriptor set", new Object[0]);
            }
            return descriptorSet;
        }
        catch (IOException e) {
            throw new ParseException(this.descriptorFilePath, (Throwable)e, "Failed to initialize descriptor at [%s]", new Object[]{this.descriptorFilePath});
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileBasedProtobufBytesDecoder that = (FileBasedProtobufBytesDecoder)o;
        return Objects.equals(this.descriptorFilePath, that.descriptorFilePath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.descriptorFilePath);
    }
}

