/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public class KubernetesOverlordUtils {
    private static final Pattern K8S_LABEL_PATTERN = Pattern.compile("[^A-Za-z0-9_.-]");
    private static final Pattern K8S_TASK_ID_PATTERN = Pattern.compile("[^a-zA-Z0-9\\\\s]");

    public static String convertStringToK8sLabel(String rawString) {
        String trimmedString = rawString == null ? "" : RegExUtils.replaceAll((String)rawString, (Pattern)K8S_LABEL_PATTERN, (String)"");
        return StringUtils.left((String)StringUtils.strip((String)trimmedString, (String)"_.-"), (int)63);
    }

    public static String convertTaskIdToK8sLabel(String taskId) {
        return taskId == null ? "" : StringUtils.left((String)RegExUtils.replaceAll((String)taskId, (Pattern)K8S_TASK_ID_PATTERN, (String)"").toLowerCase(Locale.ENGLISH), (int)63);
    }

    public static String convertTaskIdToJobName(String k8sTaskPodNamePrefix, String taskId) {
        return k8sTaskPodNamePrefix == null || k8sTaskPodNamePrefix.isEmpty() ? KubernetesOverlordUtils.convertTaskIdToJobName(taskId) : StringUtils.left((String)RegExUtils.replaceAll((String)k8sTaskPodNamePrefix, (Pattern)K8S_TASK_ID_PATTERN, (String)"").toLowerCase(Locale.ENGLISH), (int)30) + "-" + KubernetesOverlordUtils.hashString(taskId);
    }

    public static String convertTaskIdToJobName(String taskId) {
        return taskId == null ? "" : StringUtils.left((String)RegExUtils.replaceAll((String)taskId, (Pattern)K8S_TASK_ID_PATTERN, (String)"").toLowerCase(Locale.ENGLISH), (int)30) + "-" + KubernetesOverlordUtils.hashString(taskId);
    }

    private static String hashString(String rawString) {
        return Hashing.murmur3_128().hashString((CharSequence)rawString, StandardCharsets.UTF_8).toString();
    }
}

