/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimParametersReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceClaimSpec defines how a resource is to be allocated.")
public class V1alpha2ResourceClaimSpec {
    public static final String SERIALIZED_NAME_ALLOCATION_MODE = "allocationMode";
    @SerializedName(value="allocationMode")
    private String allocationMode;
    public static final String SERIALIZED_NAME_PARAMETERS_REF = "parametersRef";
    @SerializedName(value="parametersRef")
    private V1alpha2ResourceClaimParametersReference parametersRef;
    public static final String SERIALIZED_NAME_RESOURCE_CLASS_NAME = "resourceClassName";
    @SerializedName(value="resourceClassName")
    private String resourceClassName;

    public V1alpha2ResourceClaimSpec allocationMode(String allocationMode) {
        this.allocationMode = allocationMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allocation can start immediately or when a Pod wants to use the resource. \"WaitForFirstConsumer\" is the default.")
    public String getAllocationMode() {
        return this.allocationMode;
    }

    public void setAllocationMode(String allocationMode) {
        this.allocationMode = allocationMode;
    }

    public V1alpha2ResourceClaimSpec parametersRef(V1alpha2ResourceClaimParametersReference parametersRef) {
        this.parametersRef = parametersRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha2ResourceClaimParametersReference getParametersRef() {
        return this.parametersRef;
    }

    public void setParametersRef(V1alpha2ResourceClaimParametersReference parametersRef) {
        this.parametersRef = parametersRef;
    }

    public V1alpha2ResourceClaimSpec resourceClassName(String resourceClassName) {
        this.resourceClassName = resourceClassName;
        return this;
    }

    @ApiModelProperty(required=true, value="ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.")
    public String getResourceClassName() {
        return this.resourceClassName;
    }

    public void setResourceClassName(String resourceClassName) {
        this.resourceClassName = resourceClassName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2ResourceClaimSpec v1alpha2ResourceClaimSpec = (V1alpha2ResourceClaimSpec)o;
        return Objects.equals(this.allocationMode, v1alpha2ResourceClaimSpec.allocationMode) && Objects.equals(this.parametersRef, v1alpha2ResourceClaimSpec.parametersRef) && Objects.equals(this.resourceClassName, v1alpha2ResourceClaimSpec.resourceClassName);
    }

    public int hashCode() {
        return Objects.hash(this.allocationMode, this.parametersRef, this.resourceClassName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2ResourceClaimSpec {\n");
        sb.append("    allocationMode: ").append(this.toIndentedString(this.allocationMode)).append("\n");
        sb.append("    parametersRef: ").append(this.toIndentedString(this.parametersRef)).append("\n");
        sb.append("    resourceClassName: ").append(this.toIndentedString(this.resourceClassName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

