/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure.blob;

import com.azure.storage.blob.models.BlobItem;
import java.util.Date;

public class CloudBlobHolder {
    private final BlobItem delegate;
    private final String container;
    private final String storageAccount;

    public CloudBlobHolder(BlobItem delegate, String container, String storageAccount) {
        this.delegate = delegate;
        this.container = container;
        this.storageAccount = storageAccount;
    }

    public String getContainerName() {
        return this.container;
    }

    public String getStorageAccount() {
        return this.storageAccount;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public long getBlobLength() {
        return this.delegate.getProperties().getContentLength();
    }

    public Date getLastModifed() {
        return Date.from(this.delegate.getProperties().getLastModified().toInstant());
    }
}

