/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.sql.Connection;
import org.apache.empire.commons.Attributes;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.Options;
import org.apache.empire.data.DataType;
import org.apache.empire.data.Record;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBGeneratedValue;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBTable;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.InvalidPropertyException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.PropertyReadOnlyException;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DBTableColumn
extends DBColumn {
    private static final Logger log = LoggerFactory.getLogger(DBTableColumn.class);
    public static final String DBCOLATTR_SINGLEBYTECHARS = "singleByteChars";
    protected DataType type;
    protected double size;
    protected boolean required;
    protected boolean autoGenerated;
    protected boolean readOnly;
    protected Object defaultValue;
    protected int decimalScale = 0;

    public DBTableColumn(DBTable table, DataType type, String name, double size, boolean required, boolean autoGenerated, Object defValue) {
        super(table, name);
        this.type = type;
        this.required = required;
        this.autoGenerated = autoGenerated;
        this.readOnly = autoGenerated;
        this.defaultValue = defValue;
        this.attributes = new Attributes();
        this.options = null;
        this.setSize(size);
    }

    protected DBTableColumn(DBTable newTable, DBTableColumn other) {
        super(newTable, other.name);
        this.type = other.type;
        this.size = other.size;
        this.required = other.required;
        this.autoGenerated = other.autoGenerated;
        this.readOnly = other.readOnly;
        this.defaultValue = other.defaultValue;
        this.attributes = new Attributes();
        this.attributes.addAll(other.attributes);
        this.options = other.options;
        if (newTable != null) {
            newTable.addColumn(this);
        }
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defValue) {
        this.defaultValue = defValue;
    }

    public Object getRecordDefaultValue(Record record, Connection conn) {
        if (this.rowset == null) {
            return this.defaultValue;
        }
        if (!this.isAutoGenerated()) {
            return this.defaultValue;
        }
        if (this.defaultValue instanceof DBGeneratedValue) {
            return ((DBGeneratedValue)this.defaultValue).eval(record);
        }
        if (conn == null) {
            return null;
        }
        DBDatabase db = this.rowset.getDatabase();
        return db.getDbms().getColumnAutoValue(db, this, conn);
    }

    @Override
    public DataType getDataType() {
        return this.type;
    }

    @Override
    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        if (size < 0.0) {
            if (!this.getDataType().isText()) {
                throw new InvalidArgumentException("size", size);
            }
            this.setAttribute(DBCOLATTR_SINGLEBYTECHARS, Boolean.TRUE);
            size = Math.abs(size);
        } else if (this.attributes != null && this.attributes.contains(DBCOLATTR_SINGLEBYTECHARS)) {
            this.attributes.remove(DBCOLATTR_SINGLEBYTECHARS);
        }
        this.size = size;
        if (this.getDataType() == DataType.DECIMAL) {
            int reqPrec = (int)size;
            this.decimalScale = (int)(size * 10.0) - reqPrec * 10;
        }
    }

    public int getDecimalScale() {
        return this.decimalScale;
    }

    public void setDecimalScale(int scale) {
        if (this.getDataType() != DataType.DECIMAL) {
            throw new NotSupportedException(this, "setDecimalScale");
        }
        this.decimalScale = scale;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public boolean isSingleByteChars() {
        if (this.attributes == null || !this.attributes.contains(DBCOLATTR_SINGLEBYTECHARS)) {
            return false;
        }
        return ObjectUtils.getBoolean(this.attributes.get(DBCOLATTR_SINGLEBYTECHARS));
    }

    public void setSingleByteChars(boolean singleByteChars) {
        if (!this.getDataType().isText()) {
            throw new NotSupportedException(this, "setSingleByteChars");
        }
        this.setAttribute(DBCOLATTR_SINGLEBYTECHARS, singleByteChars);
    }

    public void setRequired(boolean required) {
        if (this.isAutoGenerated()) {
            throw new PropertyReadOnlyException("required");
        }
        this.required = required;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setEnumOptions(Class<? extends Enum<?>> enumType) {
        log.debug("Adding enum options of type {} for column {}.", (Object)enumType.getName(), (Object)this.getName());
        this.options = new Options(enumType);
        this.setAttribute("enumType", enumType);
        if (this.getDataType().isNumeric()) {
            return;
        }
        int maxLength = (int)this.size;
        for (OptionEntry oe : this.options) {
            String val = oe.getValueString();
            if (val == null || val.length() <= maxLength) continue;
            throw new InvalidPropertyException(enumType.getName(), val);
        }
    }

    @Override
    public Object validateValue(Object value) {
        return ((DBTable)this.rowset).validateValue(this, value);
    }

    public DBRelation.DBReference referenceOn(DBTableColumn target) {
        return new DBRelation.DBReference(this, target);
    }

    @Override
    public Element addXml(Element parent, long flags) {
        int keyIndex;
        Element elem = XMLUtil.addElement(parent, "column");
        elem.setAttribute("name", this.name);
        DBIndex primaryKey = ((DBTable)this.rowset).getPrimaryKey();
        if (primaryKey != null && (keyIndex = ((DBTable)this.rowset).getPrimaryKey().getColumnPos(this)) >= 0) {
            elem.setAttribute("key", String.valueOf(keyIndex + 1));
        }
        if (this.size > 0.0) {
            elem.setAttribute("size", String.valueOf((int)this.size));
            if (this.getDataType() == DataType.DECIMAL) {
                elem.setAttribute("decimals", String.valueOf((int)(this.size * 10.0) % 10));
            }
        }
        if (this.isRequired()) {
            elem.setAttribute("mandatory", String.valueOf(Boolean.TRUE));
        }
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        if (this.options != null) {
            this.options.addXml(elem, this.type);
        }
        return elem;
    }
}

