/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.exceptions;

import org.apache.empire.commons.ErrorType;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Entity;
import org.apache.empire.data.Record;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.exceptions.EmpireException;

public abstract class RecordException
extends EmpireException {
    private static final long serialVersionUID = 1L;
    private static final Object[] NO_KEY = new Object[0];
    private final transient Entity entity;
    private final transient Object[] key;

    protected static Object[] getKey(Record rec) {
        try {
            if (!rec.isValid() || ObjectUtils.isEmpty(rec.getKeyColumns())) {
                return NO_KEY;
            }
            return rec.getKey();
        }
        catch (Exception e) {
            return NO_KEY;
        }
    }

    protected static Entity getEntity(Record record) {
        try {
            return record.getEntity();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static String keyToString(Object[] key) {
        return key != null ? StringUtils.arrayToString(key, StringUtils.LIST_TEMPLATE) : "[]";
    }

    protected static String entityName(Entity entity) {
        return entity != null ? entity.getEntityName() : "{Null}";
    }

    protected static String rowsetName(DBRowSet rowset) {
        return rowset != null ? StringUtils.coalesce(rowset.getName(), rowset.getAlias()) : "{Null}";
    }

    public RecordException(Entity entity, Object[] key, ErrorType errType, String[] params, Throwable cause) {
        super(errType, params, cause);
        this.entity = entity;
        this.key = key;
    }

    public RecordException(Entity entity, Object[] key, ErrorType errType, String[] params) {
        this(entity, key, errType, params, null);
    }

    public RecordException(Record record, ErrorType errType, String[] params) {
        this(RecordException.getEntity(record), RecordException.getKey(record), errType, params, null);
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Object[] getKey() {
        return this.key;
    }
}

