/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.redis.cloudevent;

import io.cloudevents.CloudEvent;
import io.cloudevents.jackson.JsonFormat;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class CloudEventCodec
extends BaseCodec {
    private static final CloudEventCodec INSTANCE = new CloudEventCodec();
    private static final JsonFormat jsonFormat = new JsonFormat(false, true);
    private static final Encoder encoder = in -> {
        ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
        if (in instanceof CloudEvent) {
            out.writeBytes(jsonFormat.serialize((CloudEvent)in));
            return out;
        }
        throw new IllegalStateException("Illegal object type: " + in.getClass().getSimpleName());
    };
    private static final Decoder<Object> decoder = (buf, state) -> {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), bytes);
        return jsonFormat.deserialize(bytes);
    };

    private CloudEventCodec() {
    }

    public static CloudEventCodec getInstance() {
        return INSTANCE;
    }

    public Decoder<Object> getValueDecoder() {
        return decoder;
    }

    public Encoder getValueEncoder() {
        return encoder;
    }
}

