/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.filter.config;

import com.alibaba.druid.filter.FilterAdapter;
import com.alibaba.druid.filter.config.ConfigTools;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.security.PublicKey;
import java.sql.SQLException;
import java.util.Properties;

public class ConfigFilter
extends FilterAdapter {
    private static final Log LOG = LogFactory.getLog(ConfigFilter.class);
    public static final String CONFIG_FILE = "config.file";
    public static final String CONFIG_DECRYPT = "config.decrypt";
    public static final String CONFIG_KEY = "config.decrypt.key";
    public static final String SYS_PROP_CONFIG_FILE = "druid.config.file";
    public static final String SYS_PROP_CONFIG_DECRYPT = "druid.config.decrypt";
    public static final String SYS_PROP_CONFIG_KEY = "druid.config.decrypt.key";

    @Override
    public void init(DataSourceProxy dataSourceProxy) {
        if (!(dataSourceProxy instanceof DruidDataSource)) {
            throw new IllegalArgumentException("ConfigLoader only support DruidDataSource");
        }
        DruidDataSource dataSource = (DruidDataSource)dataSourceProxy;
        Properties connectionProperties = dataSource.getConnectProperties();
        Properties configFileProperties = this.loadPropertyFromConfigFile(connectionProperties);
        boolean decrypt = this.isDecrypt(connectionProperties, configFileProperties);
        if (configFileProperties == null) {
            if (decrypt) {
                this.decrypt(dataSource, null);
            }
            return;
        }
        if (decrypt) {
            this.decrypt(dataSource, configFileProperties);
        }
        try {
            DruidDataSourceFactory.config(dataSource, configFileProperties);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("Config DataSource error.", e);
        }
    }

    public boolean isDecrypt(Properties connectionProperties, Properties configFileProperties) {
        String decrypterId = connectionProperties.getProperty(CONFIG_DECRYPT);
        if ((decrypterId == null || decrypterId.length() == 0) && configFileProperties != null) {
            decrypterId = configFileProperties.getProperty(CONFIG_DECRYPT);
        }
        if (decrypterId == null || decrypterId.length() == 0) {
            decrypterId = System.getProperty(SYS_PROP_CONFIG_DECRYPT);
        }
        return Boolean.valueOf(decrypterId);
    }

    Properties loadPropertyFromConfigFile(Properties connectionProperties) {
        String configFile = connectionProperties.getProperty(CONFIG_FILE);
        if (configFile == null) {
            configFile = System.getProperty(SYS_PROP_CONFIG_FILE);
        }
        if (configFile != null && configFile.length() > 0) {
            Properties info;
            if (LOG.isInfoEnabled()) {
                LOG.info("DruidDataSource Config File load from : " + configFile);
            }
            if ((info = this.loadConfig(configFile)) == null) {
                throw new IllegalArgumentException("Cannot load remote config file from the [config.file=" + configFile + "].");
            }
            return info;
        }
        return null;
    }

    public void decrypt(DruidDataSource dataSource, Properties info) {
        try {
            String encryptedPassword = null;
            if (info != null) {
                encryptedPassword = info.getProperty("password");
            }
            if (encryptedPassword == null || encryptedPassword.length() == 0) {
                encryptedPassword = dataSource.getConnectProperties().getProperty("password");
            }
            if (encryptedPassword == null || encryptedPassword.length() == 0) {
                encryptedPassword = dataSource.getPassword();
            }
            PublicKey publicKey = this.getPublicKey(dataSource.getConnectProperties(), info);
            String passwordPlainText = ConfigTools.decrypt(publicKey, encryptedPassword);
            if (info != null) {
                info.setProperty("password", passwordPlainText);
            } else {
                dataSource.setPassword(passwordPlainText);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to decrypt.", e);
        }
    }

    public PublicKey getPublicKey(Properties connectionProperties, Properties configFileProperties) {
        String key = null;
        if (configFileProperties != null) {
            key = configFileProperties.getProperty(CONFIG_KEY);
        }
        if (StringUtils.isEmpty(key) && connectionProperties != null) {
            key = connectionProperties.getProperty(CONFIG_KEY);
        }
        if (StringUtils.isEmpty(key)) {
            key = System.getProperty(SYS_PROP_CONFIG_KEY);
        }
        return ConfigTools.getPublicKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadConfig(String filePath) {
        Properties properties;
        boolean xml;
        InputStream inStream;
        Properties properties2;
        block13: {
            properties2 = new Properties();
            inStream = null;
            xml = false;
            if (filePath.startsWith("file://")) {
                filePath = filePath.substring("file://".length());
                inStream = this.getFileAsStream(filePath);
                xml = filePath.endsWith(".xml");
            } else if (filePath.startsWith("http://") || filePath.startsWith("https://")) {
                URL url = new URL(filePath);
                inStream = url.openStream();
                xml = url.getPath().endsWith(".xml");
            } else if (filePath.startsWith("classpath:")) {
                String resourcePath = filePath.substring("classpath:".length());
                inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
                xml = resourcePath.endsWith(".xml");
            } else {
                inStream = this.getFileAsStream(filePath);
                xml = filePath.endsWith(".xml");
            }
            if (inStream != null) break block13;
            LOG.error("load config file error, file : " + filePath);
            properties = null;
            JdbcUtils.close(inStream);
            return properties;
        }
        try {
            if (xml) {
                properties2.loadFromXML(inStream);
            } else {
                properties2.load(inStream);
            }
            properties = properties2;
        }
        catch (Exception ex) {
            try {
                LOG.error("load config file error, file : " + filePath, ex);
                properties = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(inStream);
                throw throwable;
            }
            JdbcUtils.close(inStream);
            return properties;
        }
        JdbcUtils.close(inStream);
        return properties;
    }

    private InputStream getFileAsStream(String filePath) throws FileNotFoundException {
        InputStream inStream = null;
        File file = new File(filePath);
        inStream = file.exists() ? new FileInputStream(file) : Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
        return inStream;
    }
}

