/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.sink.handle;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.JdbcSinkConfig;
import org.apache.eventmesh.common.utils.LogUtil;
import org.apache.eventmesh.connector.jdbc.CatalogChanges;
import org.apache.eventmesh.connector.jdbc.DataChanges;
import org.apache.eventmesh.connector.jdbc.Field;
import org.apache.eventmesh.connector.jdbc.JdbcConnectData;
import org.apache.eventmesh.connector.jdbc.Payload;
import org.apache.eventmesh.connector.jdbc.Schema;
import org.apache.eventmesh.connector.jdbc.common.EnumeratedValue;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.event.DataChangeEventType;
import org.apache.eventmesh.connector.jdbc.event.SchemaChangeEventType;
import org.apache.eventmesh.connector.jdbc.sink.handle.DialectAssemblyLine;
import org.apache.eventmesh.connector.jdbc.sink.handle.DialectAssemblyLineFactory;
import org.apache.eventmesh.connector.jdbc.sink.handle.SinkRecordHandler;
import org.apache.eventmesh.connector.jdbc.source.SourceMateData;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.type.Type;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSinkRecordHandler
implements SinkRecordHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSinkRecordHandler.class);
    protected DatabaseDialect<?> eventMeshDialect;
    protected Dialect hibernateDialect;
    protected DialectAssemblyLine dialectAssemblyLine;
    private SessionFactory sessionFactory;
    private final StatelessSession session;
    private final JdbcSinkConfig jdbcSinkConfig;

    public DefaultSinkRecordHandler(DatabaseDialect<?> eventMeshDialect, SessionFactory sessionFactory, JdbcSinkConfig jdbcSinkConfig) {
        this.eventMeshDialect = eventMeshDialect;
        this.sessionFactory = sessionFactory;
        this.hibernateDialect = ((SessionFactoryImplementor)sessionFactory.unwrap(SessionFactoryImplementor.class)).getJdbcServices().getDialect();
        this.session = this.sessionFactory.openStatelessSession();
        this.dialectAssemblyLine = DialectAssemblyLineFactory.build(eventMeshDialect, this.hibernateDialect);
        this.jdbcSinkConfig = jdbcSinkConfig;
    }

    @Override
    public void handle(JdbcConnectData connectData) throws Exception {
        Payload payload = connectData.getPayload();
        SourceMateData sourceMateData = payload.ofSourceMateData();
        if (connectData.isSchemaChanges()) {
            this.schemaChangeHandle(sourceMateData, payload);
        } else if (connectData.isDataChanges()) {
            this.dataChangesHandle(connectData, sourceMateData, payload);
        } else {
            log.warn("Unknown connect data type: {}", (Object)connectData.getType());
        }
    }

    private void dataChangesHandle(JdbcConnectData connectData, SourceMateData sourceMateData, Payload payload) throws SQLException {
        DataHandleMode dataHandleMode = this.convert2DataHandleMode(DataChangeEventType.parseFromCode(connectData.getPayload().getDataChanges().getType()));
        switch (dataHandleMode) {
            case INSERT: {
                String sql = this.dialectAssemblyLine.getInsertStatement(sourceMateData, connectData.getSchema(), payload.ofDdl());
                this.insert(sql, connectData.getSchema(), payload.ofDataChanges());
                break;
            }
            case UPDATE: {
                String sql = this.dialectAssemblyLine.getUpdateStatement(sourceMateData, connectData.getSchema(), payload.ofDdl());
                this.update(sql, connectData.getSchema(), payload.ofDataChanges());
                break;
            }
            case UPSERT: {
                String sql = this.dialectAssemblyLine.getUpsertStatement(sourceMateData, connectData.getSchema(), payload.ofDdl());
                this.upsert(sql, connectData.getSchema(), payload.ofDataChanges());
                break;
            }
            case DELETE: {
                if (this.jdbcSinkConfig.isSupportDelete()) {
                    String sql = this.dialectAssemblyLine.getDeleteStatement(sourceMateData, connectData.getSchema(), payload.ofDdl());
                    this.delete(sql, connectData.getSchema(), payload.ofDataChanges());
                    break;
                }
                log.warn("No support for DELETE");
                break;
            }
            case NONE: {
                log.warn("No data changes to handle");
                break;
            }
            default: {
                log.warn("Unknown data changes type: {}", (Object)connectData.getPayload().getDataChanges().getType());
            }
        }
    }

    private void schemaChangeHandle(SourceMateData sourceMateData, Payload payload) throws SQLException {
        CatalogChanges catalogChanges = payload.ofCatalogChanges();
        SchemaChangeEventType schemaChangeEventType = SchemaChangeEventType.ofSchemaChangeEventType(catalogChanges.getType(), catalogChanges.getOperationType());
        if (schemaChangeEventType == SchemaChangeEventType.DATABASE_CREATE && this.eventMeshDialect.databaseExists(catalogChanges.getCatalog().getName())) {
            log.warn("Database {} already exists", (Object)catalogChanges.getCatalog().getName());
            return;
        }
        if (schemaChangeEventType == SchemaChangeEventType.TABLE_CREATE && this.eventMeshDialect.tableExists(catalogChanges.getTable().getTableId())) {
            log.warn("Table {} already exists", (Object)catalogChanges.getTable().getTableId());
            return;
        }
        String sql = this.dialectAssemblyLine.getDatabaseOrTableStatement(sourceMateData, catalogChanges, payload.ofDdl());
        this.applyDatabaseAndTableChanges(sql);
    }

    private void applyDatabaseAndTableChanges(String sql) {
        Transaction transaction = this.session.beginTransaction();
        try {
            LogUtil.debug((Logger)log, (String)"Execute database/table sql: {}", () -> sql);
            this.session.createNativeQuery(sql).executeUpdate();
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            throw new RuntimeException(e);
        }
    }

    private void insert(String sql, Schema schema, DataChanges dataChanges) throws SQLException {
        Transaction transaction = this.session.beginTransaction();
        try {
            if (log.isDebugEnabled()) {
                log.debug("execute insert sql: {}", (Object)sql);
            }
            NativeQuery query = this.session.createNativeQuery(sql);
            AtomicInteger index = new AtomicInteger(1);
            Map dataChangesAfter = (Map)dataChanges.getAfter();
            Field after = schema.getFields().get(0);
            after.getFields().stream().map(field -> field.getColumn()).sorted(Comparator.comparingInt(Column::getOrder)).forEach(column -> {
                Type type = this.eventMeshDialect.getType((Column<?>)column);
                int bindValueNum = type.bindValue(index.get(), type.convert2DatabaseTypeValue(dataChangesAfter.get(column.getName())), (Query<?>)query);
                index.addAndGet(bindValueNum);
            });
            int result = query.executeUpdate();
            if (result != 1) {
                throw new SQLException("Failed to insert row from table");
            }
            transaction.commit();
        }
        catch (SQLException e) {
            transaction.rollback();
            throw e;
        }
    }

    private void update(String sql, Schema schema, DataChanges dataChanges) throws SQLException {
        Transaction transaction = this.session.beginTransaction();
        try {
            if (log.isDebugEnabled()) {
                log.debug("execute update sql: {}", (Object)sql);
            }
            NativeQuery query = this.session.createNativeQuery(sql);
            AtomicInteger index = new AtomicInteger(1);
            Map dataChangesAfter = (Map)dataChanges.getAfter();
            Field after = schema.getFields().get(0);
            Map<String, Column> columnMap = after.getFields().stream().map(field -> field.getColumn()).collect(Collectors.toMap(Column::getName, column -> column));
            Set<String> keySet = schema.getKeySet();
            after.getFields().stream().map(field -> field.getColumn()).sorted(Comparator.comparingInt(Column::getOrder)).filter(column -> !keySet.contains(column.getName())).forEach(column -> {
                Type type = this.eventMeshDialect.getType((Column<?>)column);
                int bindValueNum = type.bindValue(index.get(), type.convert2DatabaseTypeValue(dataChangesAfter.get(column.getName())), (Query<?>)query);
                index.addAndGet(bindValueNum);
            });
            schema.getKeySet().stream().forEach(key -> {
                if (columnMap.containsKey(key)) {
                    Type type = this.eventMeshDialect.getType((Column)columnMap.get(key));
                    int bindValueNum = type.bindValue(index.get(), type.convert2DatabaseTypeValue(dataChangesAfter.get(key)), (Query<?>)query);
                    index.addAndGet(bindValueNum);
                }
            });
            int result = query.executeUpdate();
            if (result != 1) {
                throw new SQLException("Failed to update row from table");
            }
            transaction.commit();
        }
        catch (SQLException e) {
            transaction.rollback();
            throw e;
        }
    }

    private void upsert(String sql, Schema schema, DataChanges dataChanges) throws SQLException {
        Transaction transaction = this.session.beginTransaction();
        try {
            if (log.isDebugEnabled()) {
                log.debug("execute upsert sql: {}", (Object)sql);
            }
            NativeQuery query = this.session.createNativeQuery(sql);
            AtomicInteger index = new AtomicInteger(1);
            Map dataChangesAfter = (Map)dataChanges.getAfter();
            Field after = schema.getFields().get(0);
            after.getFields().stream().map(field -> field.getColumn()).sorted(Comparator.comparingInt(Column::getOrder)).forEach(column -> {
                Type type = this.eventMeshDialect.getType((Column<?>)column);
                int bindValueNum = type.bindValue(index.get(), type.convert2DatabaseTypeValue(dataChangesAfter.get(column.getName())), (Query<?>)query);
                index.addAndGet(bindValueNum);
            });
            int result = query.executeUpdate();
            if (result == 0) {
                throw new SQLException("Failed to update row from table");
            }
            transaction.commit();
        }
        catch (SQLException e) {
            transaction.rollback();
            throw e;
        }
    }

    private void delete(String sql, Schema schema, DataChanges dataChanges) throws SQLException {
        Transaction transaction = this.session.beginTransaction();
        try {
            LogUtil.debug((Logger)log, (String)"execute delete sql: {}", () -> sql);
            if (CollectionUtils.isEmpty(schema.getKeySet())) {
                log.warn("No primary key found, skip delete");
                return;
            }
            NativeQuery query = this.session.createNativeQuery(sql);
            AtomicInteger index = new AtomicInteger(1);
            Map dataChangesAfter = (Map)dataChanges.getBefore();
            Map<String, Column> columnMap = schema.getFields().get(0).getFields().stream().map(field -> field.getColumn()).collect(Collectors.toMap(Column::getName, column -> column));
            schema.getKeySet().stream().forEach(columnName -> {
                Column column = (Column)columnMap.get(columnName);
                Type type = this.eventMeshDialect.getType(column);
                int bindValueNum = type.bindValue(index.get(), type.convert2DatabaseTypeValue(dataChangesAfter.get(column.getName())), (Query<?>)query);
                index.addAndGet(bindValueNum);
            });
            int result = query.executeUpdate();
            if (result != 1) {
                throw new SQLException("Failed to delete row from table");
            }
            transaction.commit();
        }
        catch (SQLException e) {
            transaction.rollback();
            throw e;
        }
    }

    private DataHandleMode convert2DataHandleMode(DataChangeEventType type) {
        switch (type) {
            case INSERT: {
                return DataHandleMode.INSERT;
            }
            case UPDATE: {
                return this.jdbcSinkConfig.isSupportUpsert() ? DataHandleMode.UPSERT : DataHandleMode.UPDATE;
            }
            case DELETE: {
                return this.jdbcSinkConfig.isSupportDelete() ? DataHandleMode.DELETE : DataHandleMode.NONE;
            }
        }
        return DataHandleMode.NONE;
    }

    public static enum DataHandleMode implements EnumeratedValue<String>
    {
        INSERT("insert"),
        UPSERT("upsert"),
        UPDATE("update"),
        DELETE("delete"),
        NONE("none");

        private String value;

        private DataHandleMode(String value) {
            this.value = value;
        }

        public static DataHandleMode forValue(String value) {
            for (DataHandleMode mode : DataHandleMode.values()) {
                if (!mode.getValue().equalsIgnoreCase(value)) continue;
                return mode;
            }
            throw new IllegalArgumentException("No enum constant " + DataHandleMode.class.getName() + "." + value);
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

