/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl;

import io.grpc.Server;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcServerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcServerHelper.class);

    public static boolean shutdownAndAwaitTermination(Server server) {
        return GrpcServerHelper.shutdownAndAwaitTermination(server, 1000L);
    }

    public static boolean shutdownAndAwaitTermination(Server server, long timeoutMillis) {
        if (server == null) {
            return true;
        }
        server.shutdown();
        TimeUnit unit = TimeUnit.MILLISECONDS;
        long phaseOne = timeoutMillis / 5L;
        try {
            if (server.awaitTermination(phaseOne, unit)) {
                return true;
            }
            server.shutdownNow();
            if (server.awaitTermination(timeoutMillis - phaseOne, unit)) {
                return true;
            }
            LOG.warn("Fail to shutdown grpc server: {}.", (Object)server);
        }
        catch (InterruptedException e) {
            server.shutdownNow();
            Thread.currentThread().interrupt();
        }
        return false;
    }
}

