/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.meta.raft;

import com.alipay.remoting.exception.CodecException;
import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Iterator;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.core.StateMachineAdapter;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.eventmesh.meta.raft.EventClosure;
import org.apache.eventmesh.meta.raft.EventOperation;
import org.apache.eventmesh.meta.raft.serialize.EventMeshHessianSerializer;
import org.apache.eventmesh.meta.raft.snapshot.MetaSnapshotFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStateMachine
extends StateMachineAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaStateMachine.class);
    private final AtomicLong leaderTerm = new AtomicLong(-1L);
    private static ObjectMapper objectMapper = new ObjectMapper();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private Map<String, String> contentTable = new ConcurrentHashMap<String, String>();

    public boolean isLeader() {
        return this.leaderTerm.get() > 0L;
    }

    public boolean onSnapshotLoad(SnapshotReader reader) {
        if (this.isLeader()) {
            log.warn("Leader is not supposed to load snapshot");
            return false;
        }
        if (reader.getFileMeta("data") == null) {
            log.error("Fail to find data file in {}", (Object)reader.getPath());
            return false;
        }
        MetaSnapshotFile snapshot = new MetaSnapshotFile(reader.getPath() + File.separator + "data");
        try {
            Map snapshotLoaded = (Map)objectMapper.readValue(snapshot.load(), Map.class);
            this.contentTable.clear();
            this.contentTable.putAll(snapshotLoaded);
            return true;
        }
        catch (IOException e) {
            log.error("Fail to load snapshot from {}", (Object)snapshot.getPath());
            return false;
        }
    }

    public void onSnapshotSave(SnapshotWriter writer, Closure done) {
        this.executor.submit(() -> {
            MetaSnapshotFile snapshot = new MetaSnapshotFile(writer.getPath() + File.separator + "data");
            try {
                if (snapshot.save(objectMapper.writeValueAsString(this.contentTable))) {
                    if (writer.addFile("data")) {
                        done.run(Status.OK());
                    } else {
                        done.run(new Status(RaftError.EIO, "Fail to add file to writer", new Object[0]));
                    }
                } else {
                    done.run(new Status(RaftError.EIO, "Fail to save snapshot %s", new Object[]{snapshot.getPath()}));
                }
            }
            catch (IOException e) {
                done.run(new Status(RaftError.EIO, "Fail to deserialize snapshot %s", new Object[]{snapshot.getPath()}));
            }
        });
    }

    public void onApply(Iterator iter) {
        while (iter.hasNext()) {
            CodecException e1 = null;
            EventOperation eventOperation = null;
            EventClosure closure = null;
            if (iter.done() != null) {
                closure = (EventClosure)iter.done();
                eventOperation = closure.getEventOperation();
            } else {
                ByteBuffer data = iter.getData();
                try {
                    eventOperation = (EventOperation)EventMeshHessianSerializer.getInstance().deserialize(data.array(), EventOperation.class.getName());
                }
                catch (CodecException e) {
                    e.printStackTrace(System.err);
                    e1 = e;
                }
                if (eventOperation != null && eventOperation.isReadOp()) {
                    iter.next();
                    continue;
                }
            }
            if (eventOperation != null) {
                switch (eventOperation.getOp()) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        Map<String, String> tempTable = eventOperation.getData();
                        this.contentTable.putAll(tempTable);
                        log.info("update MetaStateMachine successfully {}", this.contentTable);
                        break;
                    }
                    case 3: {
                        Map<String, String> tempTable2 = eventOperation.getData();
                        tempTable2.forEach((key, value) -> {
                            String remove = this.contentTable.remove(key);
                            if (Objects.isNull(remove)) {
                                log.warn("delete MetaStateMachine key: {} fail.", (Object)remove);
                            } else {
                                log.info("delete MetaStateMachine key: {} successfully.", (Object)remove);
                            }
                        });
                        break;
                    }
                }
                if (closure != null) {
                    if (e1 != null) {
                        closure.failure(e1.getMessage(), "");
                    } else if (eventOperation.getOp() == 1) {
                        closure.success(Collections.EMPTY_MAP);
                    } else {
                        closure.success(Collections.unmodifiableMap(this.contentTable));
                    }
                    closure.run(Status.OK());
                }
            }
            iter.next();
        }
    }

    public void onLeaderStart(long term) {
        this.leaderTerm.set(term);
        super.onLeaderStart(term);
    }

    public void onLeaderStop(Status status) {
        this.leaderTerm.set(-1L);
        super.onLeaderStop(status);
    }
}

