/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.exception;

import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.help.FAQUrl;

public class MQBrokerException
extends Exception {
    private static final long serialVersionUID = 5975020272601250368L;
    private final int responseCode;
    private final String errorMessage;
    private final String brokerAddr;

    public MQBrokerException(int responseCode, String errorMessage) {
        super(FAQUrl.attachDefaultURL((String)("CODE: " + UtilAll.responseCode2String((int)responseCode) + "  DESC: " + errorMessage)));
        this.responseCode = responseCode;
        this.errorMessage = errorMessage;
        this.brokerAddr = null;
    }

    public MQBrokerException(int responseCode, String errorMessage, String brokerAddr) {
        super(FAQUrl.attachDefaultURL((String)("CODE: " + UtilAll.responseCode2String((int)responseCode) + "  DESC: " + errorMessage + (brokerAddr != null ? " BROKER: " + brokerAddr : ""))));
        this.responseCode = responseCode;
        this.errorMessage = errorMessage;
        this.brokerAddr = brokerAddr;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getBrokerAddr() {
        return this.brokerAddr;
    }
}

