/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.standalone.broker;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.apache.eventmesh.api.LifeCycle;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.storage.standalone.broker.model.MessageEntity;
import org.apache.eventmesh.storage.standalone.broker.model.TopicMetadata;
import org.apache.eventmesh.storage.standalone.broker.provider.DisruptorProvider;

public class Channel
implements LifeCycle {
    public static final Integer DEFAULT_SIZE = 16384;
    private DisruptorProvider provider;
    private final Integer size;
    private EventHandler<MessageEntity> eventHandler;
    private volatile boolean started = false;
    private final TopicMetadata topic;
    private static final String THREAD_NAME_PREFIX = "standalone_disruptor_provider_";

    public Channel(TopicMetadata topic) {
        this(DEFAULT_SIZE, topic, null);
    }

    public Channel(TopicMetadata topic, EventHandler<MessageEntity> eventHandler) {
        this(DEFAULT_SIZE, topic, eventHandler);
    }

    public Channel(Integer ringBufferSize, TopicMetadata topic, EventHandler<MessageEntity> eventHandler) {
        this.size = ringBufferSize;
        this.topic = topic;
        this.eventHandler = eventHandler;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public synchronized void start() {
        if (this.isClosed()) {
            this.doStart();
            this.started = true;
        }
    }

    public void doStart() {
        Disruptor disruptor = new Disruptor(MessageEntity::new, this.size.intValue(), (ThreadFactory)new EventMeshThreadFactory(THREAD_NAME_PREFIX + this.topic.getTopicName(), true), ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        disruptor.handleEventsWith(new EventHandler[]{this.eventHandler});
        disruptor.setDefaultExceptionHandler((ExceptionHandler)new IgnoreExceptionHandler());
        RingBuffer ringBuffer = disruptor.getRingBuffer();
        this.provider = new DisruptorProvider((RingBuffer<MessageEntity>)ringBuffer, (Disruptor<MessageEntity>)disruptor);
        this.provider.start();
    }

    public int getMessageCount() {
        return this.provider.getMessageCount();
    }

    public synchronized void shutdown() {
        if (this.isStarted()) {
            this.provider.shutdown();
            this.provider = null;
            this.started = false;
        }
    }

    @Generated
    public DisruptorProvider getProvider() {
        return this.provider;
    }

    @Generated
    public void setEventHandler(EventHandler<MessageEntity> eventHandler) {
        this.eventHandler = eventHandler;
    }
}

