/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.navercorp.pinpoint.profiler.cache.Cache;
import com.navercorp.pinpoint.profiler.cache.CaffeineBuilder;
import com.navercorp.pinpoint.profiler.cache.Result;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentMap;

public class UidCache
implements Cache<String, Result<byte[]>> {
    private final ConcurrentMap<String, Result<byte[]>> cache;
    private final HashFunction hashFunction = Hashing.murmur3_128();

    public UidCache(int cacheSize) {
        this.cache = this.createCache(cacheSize);
    }

    private ConcurrentMap<String, Result<byte[]>> createCache(int maxCacheSize) {
        Caffeine<Object, Object> cacheBuilder = CaffeineBuilder.newBuilder();
        cacheBuilder.initialCapacity(maxCacheSize);
        cacheBuilder.maximumSize((long)maxCacheSize);
        com.github.benmanes.caffeine.cache.Cache localCache = cacheBuilder.build();
        return localCache.asMap();
    }

    @Override
    public Result<byte[]> put(String value) {
        Result find = (Result)this.cache.get(value);
        if (find != null) {
            return find;
        }
        byte[] uid = this.calculateUid(value);
        Result<byte[]> result = new Result<byte[]>(false, uid);
        Result<byte[]> before = this.cache.putIfAbsent(value, result);
        if (before != null) {
            return before;
        }
        return new Result<byte[]>(true, uid);
    }

    private byte[] calculateUid(String value) {
        return this.hashFunction.hashString((CharSequence)value, StandardCharsets.UTF_8).asBytes();
    }
}

