/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.errorhandler;

import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.profiler.context.errorhandler.Descriptor;
import com.navercorp.pinpoint.profiler.context.errorhandler.OptionKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DescriptorParser {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Map<String, String> property;

    public DescriptorParser(Map<String, String> property) {
        this.property = Objects.requireNonNull(property, "property");
    }

    public List<Descriptor> parse() {
        Set<String> handlerIdSet = this.parseHandlerId();
        ArrayList<Descriptor> descriptorList = new ArrayList<Descriptor>();
        for (String handlerId : handlerIdSet) {
            List<String> classNameList = this.getClassName(handlerId);
            if (classNameList.isEmpty()) {
                this.logger.info("{} is empty", (Object)OptionKey.getClassName(handlerId));
                continue;
            }
            List<String> exceptionMessage = this.getExceptionMessage(handlerId);
            boolean nestedOption = this.getBooleanValue(handlerId, "nested");
            boolean parentOption = this.getBooleanValue(handlerId, "parent");
            Descriptor descriptor = new Descriptor(handlerId, classNameList, exceptionMessage, nestedOption, parentOption);
            descriptorList.add(descriptor);
        }
        return descriptorList;
    }

    private List<String> getClassName(String handlerId) {
        String classNameKey = OptionKey.getClassName(handlerId);
        String classNameValue = this.property.get(classNameKey);
        return StringUtils.tokenizeToStringList((String)classNameValue, (String)",");
    }

    private List<String> getExceptionMessage(String handlerId) {
        String exceptionMessageKey = OptionKey.getExceptionMessageContains(handlerId);
        String exceptionMessageValue = this.property.get(exceptionMessageKey);
        return StringUtils.tokenizeToStringList((String)exceptionMessageValue, (String)",");
    }

    private boolean getBooleanValue(String handlerId, String option) {
        String nestedKey = OptionKey.getKey(handlerId, option);
        String nestedValue = this.property.get(nestedKey);
        if (StringUtils.isEmpty((String)nestedValue)) {
            return true;
        }
        return Boolean.parseBoolean(nestedValue);
    }

    private Set<String> parseHandlerId() {
        HashSet<String> handlerIdSet = new HashSet<String>();
        for (String key : this.property.keySet()) {
            String handlerId = OptionKey.parseHandlerId(key);
            if (handlerId == null) continue;
            handlerIdSet.add(handlerId);
        }
        return handlerIdSet;
    }
}

