/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.exception.sampler;

import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.atomic.AtomicLong;

public class ExceptionChainSampler {
    public static final long INITIAL_EXCEPTION_ID = 1L;
    private final RateLimiter rateLimiter;
    private final AtomicLong exceptionChainId = new AtomicLong(1L);
    public static final SamplingState DISABLED = new SamplingState(){

        @Override
        public boolean isSampling() {
            return false;
        }

        @Override
        public long currentId() {
            return Long.MIN_VALUE;
        }
    };

    public ExceptionChainSampler(double maxNewThroughput) {
        this.rateLimiter = RateLimiter.create((double)maxNewThroughput);
    }

    public SamplingState isNewSampled() {
        if (this.rateLimiter.tryAcquire()) {
            long errorId = this.nextErrorId();
            return this.newState(errorId);
        }
        return DISABLED;
    }

    private long nextErrorId() {
        return this.exceptionChainId.getAndIncrement();
    }

    private SamplingState newState(final long id) {
        return new SamplingState(){

            @Override
            public boolean isSampling() {
                return true;
            }

            @Override
            public long currentId() {
                return id;
            }
        };
    }

    public static interface SamplingState {
        public boolean isSampling();

        public long currentId();
    }
}

