/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.metadata;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.profiler.message.EnhancedDataSender;
import com.navercorp.pinpoint.io.ResponseMessage;
import com.navercorp.pinpoint.profiler.cache.SimpleCache;
import com.navercorp.pinpoint.profiler.cache.UidCache;
import com.navercorp.pinpoint.profiler.context.module.MetadataDataSender;
import com.navercorp.pinpoint.profiler.context.monitor.config.MonitorConfig;
import com.navercorp.pinpoint.profiler.context.provider.metadata.SimpleCacheFactory;
import com.navercorp.pinpoint.profiler.metadata.DefaultCachingSqlNormalizer;
import com.navercorp.pinpoint.profiler.metadata.DefaultSqlMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.metadata.SqlCacheService;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.SqlUidMetaDataService;
import java.util.Objects;

public class SqlMetadataServiceProvider
implements Provider<SqlMetaDataService> {
    private final ProfilerConfig profilerConfig;
    private final MonitorConfig monitorConfig;
    private final EnhancedDataSender<MetaDataType, ResponseMessage> enhancedDataSender;
    private final SimpleCacheFactory simpleCacheFactory;

    @Inject
    public SqlMetadataServiceProvider(ProfilerConfig profilerConfig, MonitorConfig monitorConfig, @MetadataDataSender EnhancedDataSender<MetaDataType, ResponseMessage> enhancedDataSender, SimpleCacheFactory simpleCacheFactory) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.monitorConfig = Objects.requireNonNull(monitorConfig, "monitorConfig");
        this.enhancedDataSender = Objects.requireNonNull(enhancedDataSender, "enhancedDataSender");
        this.simpleCacheFactory = Objects.requireNonNull(simpleCacheFactory, "simpleCacheFactory");
    }

    public SqlMetaDataService get() {
        int jdbcSqlCacheSize = this.profilerConfig.getJdbcSqlCacheSize();
        if (this.monitorConfig.isSqlStatEnable()) {
            UidCache stringCache = new UidCache(jdbcSqlCacheSize);
            DefaultCachingSqlNormalizer<byte[]> simpleCachingSqlNormalizer = new DefaultCachingSqlNormalizer<byte[]>(stringCache);
            SqlCacheService<byte[]> sqlCacheService = new SqlCacheService<byte[]>(this.enhancedDataSender, simpleCachingSqlNormalizer);
            return new SqlUidMetaDataService(sqlCacheService);
        }
        SimpleCache<String> stringCache = this.simpleCacheFactory.newSimpleCache(jdbcSqlCacheSize);
        DefaultCachingSqlNormalizer simpleCachingSqlNormalizer = new DefaultCachingSqlNormalizer(stringCache);
        SqlCacheService<Integer> sqlCacheService = new SqlCacheService<Integer>(this.enhancedDataSender, simpleCachingSqlNormalizer);
        return new DefaultSqlMetaDataService(sqlCacheService);
    }
}

