/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.stat.jvmgc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.context.monitor.config.MonitorConfig;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.jvmgc.BasicJvmGcMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.jvmgc.DetailedJvmGcMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.JvmGcMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.DetailedGarbageCollectorMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.GarbageCollectorMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.DetailedMemoryMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.MemoryMetric;
import java.util.Objects;

public class JvmGcMetricCollectorProvider
implements Provider<AgentStatMetricCollector<JvmGcMetricSnapshot>> {
    private final boolean collectDetailedMetrics;
    private final Provider<MemoryMetric> memoryMetricProivider;
    private final Provider<DetailedMemoryMetric> detailedMemoryMetricProvider;
    private final Provider<GarbageCollectorMetric> garbageCollectorMetricProvider;
    private final Provider<DetailedGarbageCollectorMetric> detailedGarbageCollectorMetricProvider;

    @Inject
    public JvmGcMetricCollectorProvider(MonitorConfig monitorConfig, Provider<MemoryMetric> memoryMetricProivider, Provider<DetailedMemoryMetric> detailedMemoryMetricProvider, Provider<GarbageCollectorMetric> garbageCollectorMetricProvider, Provider<DetailedGarbageCollectorMetric> detailedGarbageCollectorMetricProvider) {
        Objects.requireNonNull(monitorConfig, "profilerConfig");
        this.collectDetailedMetrics = monitorConfig.isProfilerJvmStatCollectDetailedMetrics();
        this.memoryMetricProivider = Objects.requireNonNull(memoryMetricProivider, "memoryMetricProivider");
        this.detailedMemoryMetricProvider = Objects.requireNonNull(detailedMemoryMetricProvider, "detailedMemoryMetricProvider");
        this.garbageCollectorMetricProvider = Objects.requireNonNull(garbageCollectorMetricProvider, "garbageCollectorMetricProvider");
        this.detailedGarbageCollectorMetricProvider = Objects.requireNonNull(detailedGarbageCollectorMetricProvider, "detailedGarbageCollectorMetricProvider");
    }

    public AgentStatMetricCollector<JvmGcMetricSnapshot> get() {
        MemoryMetric memoryMetric = (MemoryMetric)this.memoryMetricProivider.get();
        GarbageCollectorMetric garbageCollectorMetric = (GarbageCollectorMetric)this.garbageCollectorMetricProvider.get();
        BasicJvmGcMetricCollector jvmGcMetricCollector = new BasicJvmGcMetricCollector(memoryMetric, garbageCollectorMetric);
        if (this.collectDetailedMetrics) {
            DetailedMemoryMetric detailedMemoryMetric = (DetailedMemoryMetric)this.detailedMemoryMetricProvider.get();
            DetailedGarbageCollectorMetric detailedGarbageCollectorMetric = (DetailedGarbageCollectorMetric)this.detailedGarbageCollectorMetricProvider.get();
            return new DetailedJvmGcMetricCollector(jvmGcMetricCollector, detailedMemoryMetric, detailedGarbageCollectorMetric);
        }
        return jvmGcMetricCollector;
    }
}

