/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.profiler.plugin.ClassNameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PinpointProfilerPackageFilter
implements ClassNameFilter {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final boolean debug = this.logger.isDebugEnabled();
    private final String[] packageList;

    public PinpointProfilerPackageFilter() {
        this(PinpointProfilerPackageFilter.getPinpointPackageList());
    }

    public PinpointProfilerPackageFilter(List<String> packageList) {
        Objects.requireNonNull(packageList, "packageList");
        this.packageList = packageList.toArray(new String[0]);
    }

    @Override
    public boolean accept(String className, ClassLoader classLoader) {
        for (String packageName : this.packageList) {
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getPinpointPackageList() {
        ArrayList<String> pinpointPackageList = new ArrayList<String>();
        pinpointPackageList.add("com.navercorp.pinpoint.bootstrap");
        pinpointPackageList.add("com.navercorp.pinpoint.profiler");
        pinpointPackageList.add("com.navercorp.pinpoint.common");
        pinpointPackageList.add("com.navercorp.pinpoint.exception");
        pinpointPackageList.add("com.navercorp.pinpoint.test");
        return pinpointPackageList;
    }
}

