/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.google.protobuf.Empty;
import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.common.profiler.message.MessageConverter;
import com.navercorp.pinpoint.grpc.MessageFormatUtils;
import com.navercorp.pinpoint.grpc.client.ChannelFactory;
import com.navercorp.pinpoint.grpc.trace.PAgentStat;
import com.navercorp.pinpoint.grpc.trace.PAgentStatBatch;
import com.navercorp.pinpoint.grpc.trace.PAgentUriStat;
import com.navercorp.pinpoint.grpc.trace.PCustomMetricMessage;
import com.navercorp.pinpoint.grpc.trace.PStatMessage;
import com.navercorp.pinpoint.grpc.trace.StatGrpc;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import com.navercorp.pinpoint.profiler.sender.grpc.ClientStreamingService;
import com.navercorp.pinpoint.profiler.sender.grpc.GrpcDataSender;
import com.navercorp.pinpoint.profiler.sender.grpc.MessageDispatcher;
import com.navercorp.pinpoint.profiler.sender.grpc.ReconnectExecutor;
import com.navercorp.pinpoint.profiler.sender.grpc.Reconnector;
import com.navercorp.pinpoint.profiler.sender.grpc.ResponseStreamObserver;
import com.navercorp.pinpoint.profiler.sender.grpc.SimpleStreamState;
import com.navercorp.pinpoint.profiler.sender.grpc.StreamState;
import com.navercorp.pinpoint.profiler.sender.grpc.StreamTask;
import com.navercorp.pinpoint.profiler.sender.grpc.stream.ClientStreamingProvider;
import com.navercorp.pinpoint.profiler.sender.grpc.stream.DefaultStreamTask;
import com.navercorp.pinpoint.profiler.sender.grpc.stream.StreamExecutorFactory;
import com.navercorp.pinpoint.profiler.util.NamedRunnable;
import io.grpc.Channel;
import io.grpc.stub.ClientCallStreamObserver;
import java.util.Objects;

public class StatGrpcDataSender
extends GrpcDataSender<MetricType> {
    private static final String ID = "StatStream";
    private final ReconnectExecutor reconnectExecutor;
    private final Reconnector reconnector;
    private final StreamState failState;
    private final StreamExecutorFactory<PStatMessage> streamExecutorFactory;
    private volatile StreamTask<MetricType, PStatMessage> currentStreamTask;
    private final ClientStreamingService<PStatMessage, Empty> clientStreamService;
    public MessageDispatcher<MetricType, PStatMessage> dispatcher = new MessageDispatcher<MetricType, PStatMessage>(){

        @Override
        public void onDispatch(ClientCallStreamObserver<PStatMessage> stream, MetricType data) {
            GeneratedMessageV3 message = (GeneratedMessageV3)StatGrpcDataSender.this.messageConverter.toMessage((Object)data);
            if (StatGrpcDataSender.this.isDebug) {
                StatGrpcDataSender.this.logger.debug("Send message={}", (Object)MessageFormatUtils.debugLog((GeneratedMessageV3)message));
            }
            if (message instanceof PAgentStatBatch) {
                PAgentStatBatch agentStatBatch = (PAgentStatBatch)message;
                PStatMessage statMessage = PStatMessage.newBuilder().setAgentStatBatch(agentStatBatch).build();
                stream.onNext((Object)statMessage);
                return;
            }
            if (message instanceof PAgentStat) {
                PAgentStat agentStat = (PAgentStat)message;
                PStatMessage statMessage = PStatMessage.newBuilder().setAgentStat(agentStat).build();
                stream.onNext((Object)statMessage);
                return;
            }
            if (message instanceof PCustomMetricMessage) {
                PCustomMetricMessage customMetricMessage = (PCustomMetricMessage)message;
                StatGrpcDataSender.this.logger.info("Message will not delivered. message:{}", (Object)message);
                return;
            }
            if (message instanceof PAgentUriStat) {
                PAgentUriStat agentUriStat = (PAgentUriStat)message;
                PStatMessage statMessage = PStatMessage.newBuilder().setAgentUriStat(agentUriStat).build();
                stream.onNext((Object)statMessage);
                return;
            }
            throw new IllegalStateException("unsupported message " + message);
        }
    };

    public StatGrpcDataSender(String host, int port, int executorQueueSize, MessageConverter<MetricType, GeneratedMessageV3> messageConverter, ReconnectExecutor reconnectExecutor, ChannelFactory channelFactory) {
        super(host, port, executorQueueSize, messageConverter, channelFactory);
        this.reconnectExecutor = Objects.requireNonNull(reconnectExecutor, "reconnectExecutor");
        NamedRunnable reconnectJob = new NamedRunnable(ID){

            @Override
            public void run() {
                StatGrpcDataSender.this.startStream();
            }
        };
        this.reconnector = reconnectExecutor.newReconnector(reconnectJob);
        this.failState = new SimpleStreamState(100, 5000L);
        this.streamExecutorFactory = new StreamExecutorFactory(this.executor);
        ClientStreamingProvider<PStatMessage, Empty> clientStreamProvider = new ClientStreamingProvider<PStatMessage, Empty>(){

            @Override
            public ClientCallStreamObserver<PStatMessage> newStream(ResponseStreamObserver<PStatMessage, Empty> response) {
                StatGrpcDataSender.this.logger.info("newStream {}", (Object)StatGrpcDataSender.ID);
                StatGrpc.StatStub statStub = StatGrpc.newStub((Channel)StatGrpcDataSender.this.managedChannel);
                return (ClientCallStreamObserver)statStub.sendAgentStat(response);
            }
        };
        this.clientStreamService = new ClientStreamingService<PStatMessage, Empty>(clientStreamProvider, this.reconnector);
        reconnectJob.run();
    }

    private void startStream() {
        try {
            DefaultStreamTask<MetricType, PStatMessage, Empty> streamTask = new DefaultStreamTask<MetricType, PStatMessage, Empty>(ID, this.clientStreamService, this.streamExecutorFactory, this.queue, this.dispatcher, this.failState);
            streamTask.start();
            this.currentStreamTask = streamTask;
        }
        catch (Throwable th) {
            this.logger.error("Unexpected error", th);
        }
    }

    public void stop() {
        StreamTask<MetricType, PStatMessage> currentStreamTask;
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.logger.info("Stop {}, channel={}", (Object)this.name, (Object)this.managedChannel);
        ReconnectExecutor reconnectExecutor = this.reconnectExecutor;
        if (reconnectExecutor != null) {
            reconnectExecutor.close();
        }
        if ((currentStreamTask = this.currentStreamTask) != null) {
            currentStreamTask.stop();
        }
        this.logger.info("{} close()", (Object)ID);
        this.release();
    }

    public String toString() {
        return "StatGrpcDataSender{name='" + this.name + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + "} " + super.toString();
    }
}

