/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.openfunction.source.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.openfunction.OpenFunctionSourceConfig;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFunctionSourceConnector
implements Source {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenFunctionSourceConnector.class);
    private OpenFunctionSourceConfig sourceConfig;
    private BlockingQueue<ConnectRecord> queue;
    private int maxBatchSize;
    private long maxPollWaitTime;

    public Class<? extends Config> configClass() {
        return OpenFunctionSourceConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sourceConfig = (OpenFunctionSourceConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (OpenFunctionSourceConfig)sourceConnectorContext.getSourceConfig();
        this.doInit();
    }

    private void doInit() {
        this.queue = new LinkedBlockingQueue<ConnectRecord>(this.sourceConfig.getPollConfig().getCapacity());
        this.maxBatchSize = this.sourceConfig.getPollConfig().getMaxBatchSize();
        this.maxPollWaitTime = this.sourceConfig.getPollConfig().getMaxWaitTime();
    }

    public void start() throws Exception {
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getSourceConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
    }

    public BlockingQueue<ConnectRecord> queue() {
        return this.queue;
    }

    public List<ConnectRecord> poll() {
        long startTime = System.currentTimeMillis();
        long remainingTime = this.maxPollWaitTime;
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(this.maxBatchSize);
        for (int count = 0; count < this.maxBatchSize; ++count) {
            try {
                ConnectRecord connectRecord = this.queue.poll(remainingTime, TimeUnit.MILLISECONDS);
                if (connectRecord == null) break;
                connectRecords.add(connectRecord);
                long elapsedTime = System.currentTimeMillis() - startTime;
                remainingTime = this.maxPollWaitTime > elapsedTime ? this.maxPollWaitTime - elapsedTime : 0L;
                continue;
            }
            catch (InterruptedException e) {
                Thread currentThread = Thread.currentThread();
                log.warn("[OpenFunctionSourceConnector] Interrupting thread {} due to exception {}", (Object)currentThread.getName(), (Object)e.getMessage());
                currentThread.interrupt();
            }
        }
        return connectRecords;
    }
}

